/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import java.io.Serializable;
import java.util.Objects;

public class FrontendVersion
implements Serializable,
Comparable<FrontendVersion> {
    private final String version;
    private final int majorVersion;
    private final int minorVersion;
    private final int revision;
    private final String buildIdentifier;

    public FrontendVersion(int major, int minor) {
        this(major, minor, 0);
    }

    public FrontendVersion(int major, int minor, int revision) {
        this(major, minor, revision, "");
    }

    public FrontendVersion(int major, int minor, int revision, String build) {
        this.version = build.isEmpty() ? major + "." + minor + "." + revision : major + "." + minor + "." + revision + "." + build;
        this.majorVersion = major;
        this.minorVersion = minor;
        this.revision = revision;
        this.buildIdentifier = build;
    }

    public FrontendVersion(String version) {
        int revisionNumber;
        String build;
        block5: {
            Objects.requireNonNull(version);
            this.version = !Character.isDigit(version.charAt(0)) ? version.substring(1) : version;
            String[] digits = this.version.split("[-.]", 4);
            try {
                this.majorVersion = Integer.parseInt(digits[0]);
                this.minorVersion = Integer.parseInt(digits[1]);
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException(String.format("'%s' is not a valid version!", version));
            }
            build = "";
            try {
                int n = revisionNumber = digits.length >= 3 ? Integer.parseInt(digits[2]) : 0;
                if (digits.length == 4) {
                    build = digits[3];
                }
            }
            catch (NumberFormatException e) {
                revisionNumber = 0;
                if (digits.length < 3) break block5;
                build = digits[2];
            }
        }
        this.revision = revisionNumber;
        this.buildIdentifier = build;
    }

    public String getFullVersion() {
        return this.version;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public boolean isOlderThan(FrontendVersion otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public boolean isNewerThan(FrontendVersion otherVersion) {
        return this.compareTo(otherVersion) > 0;
    }

    public boolean isEqualTo(FrontendVersion otherVersion) {
        return this.compareTo(otherVersion) == 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FrontendVersion) {
            FrontendVersion other = (FrontendVersion)obj;
            return this.majorVersion == other.getMajorVersion() && this.minorVersion == other.getMinorVersion() && this.revision == other.getRevision() && this.buildIdentifier.equals(other.getBuildIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return (this.majorVersion + "." + this.minorVersion + "." + this.revision + "." + this.buildIdentifier).hashCode();
    }

    @Override
    public int compareTo(FrontendVersion other) {
        if (this.majorVersion != other.majorVersion) {
            return Integer.compare(this.majorVersion, other.majorVersion);
        }
        if (this.minorVersion != other.minorVersion) {
            return Integer.compare(this.minorVersion, other.minorVersion);
        }
        if (this.revision != other.revision) {
            return Integer.compare(this.revision, other.revision);
        }
        if (this.buildIdentifier != other.buildIdentifier) {
            if (this.buildIdentifier.isEmpty() && !other.buildIdentifier.isEmpty()) {
                return 1;
            }
            if (!this.buildIdentifier.isEmpty() && other.buildIdentifier.isEmpty()) {
                return -1;
            }
            return this.buildIdentifier.compareToIgnoreCase(other.buildIdentifier);
        }
        return 0;
    }
}

