/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendWebComponentGenerator;
import com.vaadin.flow.server.frontend.TaskCopyFrontendFiles;
import com.vaadin.flow.server.frontend.TaskCopyLocalFrontendFiles;
import com.vaadin.flow.server.frontend.TaskGenerateConnect;
import com.vaadin.flow.server.frontend.TaskGenerateIndexHtml;
import com.vaadin.flow.server.frontend.TaskGenerateIndexTs;
import com.vaadin.flow.server.frontend.TaskGenerateOpenApi;
import com.vaadin.flow.server.frontend.TaskGeneratePackageJson;
import com.vaadin.flow.server.frontend.TaskGenerateTsConfig;
import com.vaadin.flow.server.frontend.TaskRunNpmInstall;
import com.vaadin.flow.server.frontend.TaskUpdateImports;
import com.vaadin.flow.server.frontend.TaskUpdatePackages;
import com.vaadin.flow.server.frontend.TaskUpdateWebpack;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import elemental.json.JsonObject;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class NodeTasks
implements FallibleCommand {
    private final Collection<FallibleCommand> commands = new ArrayList<FallibleCommand>();

    private NodeTasks(Builder builder) {
        ClassFinder.CachedClassFinder classFinder = new ClassFinder.CachedClassFinder(builder.classFinder);
        FrontendDependenciesScanner frontendDependencies = null;
        if (builder.enablePackagesUpdate || builder.enableImportsUpdate) {
            if (builder.generateEmbeddableWebComponents) {
                FrontendWebComponentGenerator generator = new FrontendWebComponentGenerator(classFinder);
                generator.generateWebComponents(builder.generatedFolder);
            }
            frontendDependencies = new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(!builder.useByteCodeScanner, classFinder, builder.generateEmbeddableWebComponents);
        }
        if (builder.createMissingPackageJson) {
            TaskGeneratePackageJson packageCreator = new TaskGeneratePackageJson(builder.npmFolder, builder.generatedFolder, builder.flowResourcesFolder);
            this.commands.add(packageCreator);
        }
        if (!builder.useDeprecatedV14Bootstrapping) {
            this.addBootstrapTasks(builder);
            if (builder.connectJavaSourceFolder != null && builder.connectJavaSourceFolder.exists() && builder.connectGeneratedOpenApiFile != null) {
                this.addConnectServicesTasks(builder);
            }
        }
        if (builder.enablePackagesUpdate) {
            TaskUpdatePackages packageUpdater = new TaskUpdatePackages(classFinder, frontendDependencies, builder.npmFolder, builder.generatedFolder, builder.flowResourcesFolder, builder.cleanNpmFiles, builder.enablePnpm);
            this.commands.add(packageUpdater);
            if (builder.runNpmInstall) {
                this.commands.add(new TaskRunNpmInstall(packageUpdater, builder.enablePnpm));
            }
        }
        if (builder.jarFiles != null) {
            this.commands.add(new TaskCopyFrontendFiles(builder.flowResourcesFolder, builder.jarFiles));
            if (builder.localResourcesFolder != null) {
                this.commands.add(new TaskCopyLocalFrontendFiles(builder.flowResourcesFolder, builder.localResourcesFolder));
            }
        }
        if (builder.webpackTemplate != null && !builder.webpackTemplate.isEmpty()) {
            this.commands.add(new TaskUpdateWebpack(builder.frontendDirectory, builder.npmFolder, builder.webpackOutputDirectory, builder.webpackTemplate, builder.webpackGeneratedTemplate, new File(builder.generatedFolder, "generated-flow-imports.js"), builder.useDeprecatedV14Bootstrapping));
        }
        if (builder.enableImportsUpdate) {
            this.commands.add(new TaskUpdateImports(classFinder, frontendDependencies, finder -> this.getFallbackScanner(builder, (ClassFinder)finder), builder.npmFolder, builder.generatedFolder, builder.frontendDirectory, builder.tokenFile, builder.tokenFileData, builder.enablePnpm));
        }
    }

    private void addBootstrapTasks(Builder builder) {
        File outputDirectory = new File(builder.npmFolder, "target/");
        TaskGenerateIndexHtml taskGenerateIndexHtml = new TaskGenerateIndexHtml(builder.frontendDirectory, outputDirectory);
        this.commands.add(taskGenerateIndexHtml);
        TaskGenerateIndexTs taskGenerateIndexTs = new TaskGenerateIndexTs(builder.frontendDirectory, new File(builder.generatedFolder, "generated-flow-imports.js"), outputDirectory);
        this.commands.add(taskGenerateIndexTs);
        TaskGenerateTsConfig taskGenerateTsConfig = new TaskGenerateTsConfig(builder.npmFolder);
        this.commands.add(taskGenerateTsConfig);
    }

    private void addConnectServicesTasks(Builder builder) {
        TaskGenerateOpenApi taskGenerateOpenApi = new TaskGenerateOpenApi(builder.connectApplicationProperties, builder.connectJavaSourceFolder, builder.classFinder.getClassLoader(), builder.connectGeneratedOpenApiFile);
        this.commands.add(taskGenerateOpenApi);
        if (builder.connectClientTsApiFolder != null) {
            TaskGenerateConnect taskGenerateConnectTs = new TaskGenerateConnect(builder.connectApplicationProperties, builder.connectGeneratedOpenApiFile, builder.connectClientTsApiFolder);
            this.commands.add(taskGenerateConnectTs);
        }
    }

    private FrontendDependenciesScanner getFallbackScanner(Builder builder, ClassFinder finder) {
        if (builder.useByteCodeScanner) {
            return new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(true, finder, builder.generateEmbeddableWebComponents);
        }
        return null;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        for (FallibleCommand command : this.commands) {
            command.execute();
        }
    }

    public static class Builder
    implements Serializable {
        private final ClassFinder classFinder;
        private final File frontendDirectory;
        private File webpackOutputDirectory = null;
        private String webpackTemplate = null;
        private String webpackGeneratedTemplate = null;
        private boolean enablePackagesUpdate = false;
        private boolean createMissingPackageJson = false;
        private boolean enableImportsUpdate = false;
        private boolean runNpmInstall = false;
        private Set<File> jarFiles = null;
        private boolean generateEmbeddableWebComponents = true;
        private boolean cleanNpmFiles = false;
        private File flowResourcesFolder = null;
        private File localResourcesFolder = null;
        private boolean useByteCodeScanner = false;
        private JsonObject tokenFileData;
        private File tokenFile;
        private boolean enablePnpm;
        private File connectJavaSourceFolder;
        private File connectGeneratedOpenApiFile;
        private File connectApplicationProperties;
        private File connectClientTsApiFolder;
        public final File npmFolder;
        public final File generatedFolder;
        private boolean useDeprecatedV14Bootstrapping;

        public Builder(ClassFinder classFinder, File npmFolder) {
            this(classFinder, npmFolder, new File(npmFolder, System.getProperty("vaadin.frontend.generated.folder", "target/frontend/")));
        }

        public Builder(ClassFinder classFinder, File npmFolder, File generatedPath) {
            this(classFinder, npmFolder, generatedPath, new File(npmFolder, System.getProperty("vaadin.frontend.frontend.folder", "./frontend/")));
        }

        public Builder(ClassFinder classFinder, File npmFolder, File generatedPath, File frontendDirectory) {
            this.classFinder = classFinder;
            this.npmFolder = npmFolder;
            this.generatedFolder = generatedPath.isAbsolute() ? generatedPath : new File(npmFolder, generatedPath.getPath());
            this.frontendDirectory = frontendDirectory.isAbsolute() ? frontendDirectory : new File(npmFolder, frontendDirectory.getPath());
        }

        public NodeTasks build() {
            return new NodeTasks(this);
        }

        public Builder withWebpack(File webpackOutputDirectory, String webpackTemplate, String webpackGeneratedTemplate) {
            this.webpackOutputDirectory = webpackOutputDirectory;
            this.webpackTemplate = webpackTemplate;
            this.webpackGeneratedTemplate = webpackGeneratedTemplate;
            return this;
        }

        public Builder enablePackagesUpdate(boolean enablePackagesUpdate) {
            this.enablePackagesUpdate = enablePackagesUpdate;
            return this;
        }

        public Builder enableNpmFileCleaning(boolean forceClean) {
            this.cleanNpmFiles = forceClean;
            return this;
        }

        public Builder enableImportsUpdate(boolean enableImportsUpdate) {
            this.enableImportsUpdate = enableImportsUpdate;
            this.createMissingPackageJson = enableImportsUpdate || this.createMissingPackageJson;
            return this;
        }

        public Builder runNpmInstall(boolean runNpmInstall) {
            this.runNpmInstall = runNpmInstall;
            return this;
        }

        public Builder withFlowResourcesFolder(File flowResourcesFolder) {
            this.flowResourcesFolder = flowResourcesFolder.isAbsolute() ? flowResourcesFolder : new File(this.npmFolder, flowResourcesFolder.getPath());
            return this;
        }

        public Builder copyResources(Set<File> jars) {
            Objects.requireNonNull(jars, "Parameter 'jars' must not be null!");
            this.jarFiles = jars;
            return this;
        }

        public Builder withEmbeddableWebComponents(boolean generateEmbeddableWebComponents) {
            this.generateEmbeddableWebComponents = generateEmbeddableWebComponents;
            return this;
        }

        public Builder createMissingPackageJson(boolean create) {
            this.createMissingPackageJson = create;
            return this;
        }

        public Builder copyLocalResources(File localResourcesFolder) {
            this.localResourcesFolder = localResourcesFolder;
            return this;
        }

        public Builder useV14Bootstrap(boolean useDeprecatedV14Bootstrapping) {
            this.useDeprecatedV14Bootstrapping = useDeprecatedV14Bootstrapping;
            return this;
        }

        public Builder withConnectClientTsApiFolder(File connectClientTsApiFolder) {
            this.connectClientTsApiFolder = connectClientTsApiFolder;
            return this;
        }

        public Builder withConnectApplicationProperties(File applicationProperties) {
            this.connectApplicationProperties = applicationProperties;
            return this;
        }

        public Builder withConnectGeneratedOpenApiJson(File generatedOpenApiFile) {
            this.connectGeneratedOpenApiFile = generatedOpenApiFile;
            return this;
        }

        public Builder withConnectJavaSourceFolder(File connectJavaSourceFolder) {
            this.connectJavaSourceFolder = connectJavaSourceFolder;
            return this;
        }

        public Builder useByteCodeScanner(boolean byteCodeScanner) {
            this.useByteCodeScanner = byteCodeScanner;
            return this;
        }

        public Builder populateTokenFileData(JsonObject object) {
            this.tokenFileData = object;
            return this;
        }

        public Builder withTokenFile(File tokenFile) {
            this.tokenFile = tokenFile;
            return this;
        }

        public Builder enablePnpm(boolean enable) {
            this.enablePnpm = enable;
            return this;
        }
    }
}

