/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.webcomponent;

import com.vaadin.flow.component.WebComponentExporter;
import com.vaadin.flow.component.WebComponentExporterFactory;
import com.vaadin.flow.internal.ReflectTools;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebComponentExporterUtils {
    private WebComponentExporterUtils() {
    }

    public static Set<WebComponentExporterFactory> getFactories(Set<Class<?>> classes) {
        HashSet<WebComponentExporterFactory> factories = new HashSet<WebComponentExporterFactory>();
        classes.stream().filter(WebComponentExporter.class::isAssignableFrom).filter(WebComponentExporterUtils::isEligible).map(clazz -> new WebComponentExporterFactory.DefaultWebComponentExporterFactory(clazz)).forEach(factories::add);
        classes.stream().filter(WebComponentExporterFactory.class::isAssignableFrom).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers())).filter(clazz -> !clazz.equals(WebComponentExporterFactory.DefaultWebComponentExporterFactory.class)).map(ReflectTools::createInstance).map(WebComponentExporterFactory.class::cast).forEach(factories::add);
        return factories;
    }

    private static boolean isEligible(Class<?> clazz) {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            WebComponentExporterUtils.getLogger().trace("Class {} is abstract, and won't be instantiated as a '{}' by default", (Object)clazz.getName(), (Object)WebComponentExporter.class.getSimpleName());
            return false;
        }
        if (!Modifier.isPublic(clazz.getModifiers())) {
            WebComponentExporterUtils.getLogger().trace("Class {} is not public, and won't be instantiated as a '{}' by default", (Object)clazz.getName(), (Object)WebComponentExporter.class.getSimpleName());
            return false;
        }
        Optional<Constructor> constructor = Stream.of(clazz.getConstructors()).filter(ctor -> ctor.getParameterCount() == 0).findFirst();
        if (!constructor.isPresent() || !Modifier.isPublic(constructor.get().getModifiers())) {
            WebComponentExporterUtils.getLogger().trace("Class {} has no public no-argument constructor, and won't be instantiated as a '{}' by default", (Object)clazz.getName(), (Object)WebComponentExporter.class.getSimpleName());
            return false;
        }
        if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
            WebComponentExporterUtils.getLogger().trace("Class {} is inner (nested non static) class, and won't be instantiated as a '{}' by default", (Object)clazz.getName(), (Object)WebComponentExporter.class.getSimpleName());
            return false;
        }
        return true;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(WebComponentExporterUtils.class);
    }
}

