/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class TaskGenerateServiceWorker
extends AbstractTaskClientGenerator {
    private File frontendDirectory;
    private File outputDirectory;

    TaskGenerateServiceWorker(File frontendDirectory, File outputDirectory) {
        this.frontendDirectory = frontendDirectory;
        this.outputDirectory = outputDirectory;
    }

    @Override
    protected String getFileContent() throws IOException {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream("sw.ts"), (Charset)StandardCharsets.UTF_8);
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.outputDirectory, "sw.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        File serviceWorker = new File(this.frontendDirectory, "sw.ts");
        File serviceWorkerJs = new File(this.frontendDirectory, "sw.js");
        return !serviceWorker.exists() && !serviceWorkerJs.exists();
    }
}

