/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.frontend.scanner.CssAnnotationVisitor;
import com.vaadin.flow.server.frontend.scanner.EndPointData;
import com.vaadin.flow.server.frontend.scanner.RepeatedAnnotationVisitor;
import com.vaadin.flow.theme.NoTheme;
import com.vaadin.flow.theme.Theme;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.Handle;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;

final class FrontendClassVisitor
extends ClassVisitor {
    private static final String VARIANT = "variant";
    private static final String LAYOUT = "layout";
    static final String VALUE = "value";
    static final String THEME_CLASS = "themeClass";
    static final String VERSION = "version";
    static final String ID = "id";
    static final String INCLUDE = "include";
    static final String THEME_FOR = "themeFor";
    private final String className;
    private final EndPointData endPoint;
    private final MethodVisitor methodVisitor;
    private final AnnotationVisitor annotationVisitor;
    private final AnnotationVisitor routeVisitor;
    private final AnnotationVisitor themeRouteVisitor;
    private final AnnotationVisitor themeLayoutVisitor;
    private final AnnotationVisitor jsModuleVisitor;
    private final AnnotationVisitor jScriptVisitor;
    private final Set<String> children = new HashSet<String>();

    FrontendClassVisitor(String className, final EndPointData endPoint, final boolean themeScope) {
        super(524288);
        this.className = className;
        this.endPoint = endPoint;
        this.methodVisitor = new FrontendMethodVisitor();
        this.routeVisitor = new RepeatedAnnotationVisitor(){

            @Override
            public void visit(String name, Object value) {
                if (FrontendClassVisitor.LAYOUT.equals(name)) {
                    endPoint.layout = ((Type)value).getClassName();
                    FrontendClassVisitor.this.children.add(endPoint.layout);
                }
                if (FrontendClassVisitor.VALUE.equals(name)) {
                    endPoint.route = value.toString();
                }
            }
        };
        this.themeRouteVisitor = new RepeatedAnnotationVisitor(){

            @Override
            public void visit(String name, Object value) {
                if (FrontendClassVisitor.VALUE.equals(name)) {
                    endPoint.theme.themeName = (String)value;
                } else if (FrontendClassVisitor.THEME_CLASS.equals(name)) {
                    endPoint.theme.themeClass = ((Type)value).getClassName();
                    FrontendClassVisitor.this.children.add(endPoint.theme.themeClass);
                } else if (FrontendClassVisitor.VARIANT.equals(name)) {
                    endPoint.theme.variant = value.toString();
                }
            }
        };
        this.themeLayoutVisitor = new RepeatedAnnotationVisitor(){

            @Override
            public void visit(String name, Object value) {
                if (FrontendClassVisitor.VALUE.equals(name)) {
                    FrontendClassVisitor.this.themeRouteVisitor.visit(name, value);
                } else if (FrontendClassVisitor.THEME_CLASS.equals(name) && endPoint.theme.themeClass == null) {
                    FrontendClassVisitor.this.themeRouteVisitor.visit(name, value);
                } else if (FrontendClassVisitor.VARIANT.equals(name) && endPoint.theme.variant.isEmpty()) {
                    FrontendClassVisitor.this.themeRouteVisitor.visit(name, value);
                }
            }
        };
        this.jsModuleVisitor = new RepeatedAnnotationVisitor(){

            @Override
            public void visit(String name, Object value) {
                if (themeScope) {
                    endPoint.themeModules.add(value.toString());
                } else {
                    endPoint.modules.add(value.toString());
                }
            }
        };
        this.jScriptVisitor = new RepeatedAnnotationVisitor(){

            @Override
            public void visit(String name, Object value) {
                endPoint.scripts.add(value.toString());
            }
        };
        this.annotationVisitor = new RepeatedAnnotationVisitor(){

            @Override
            public void visit(String name, Object value) {
                if (value != null && !value.getClass().isPrimitive() && !value.getClass().equals(String.class)) {
                    FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, value.toString());
                }
            }
        };
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.addSignatureToClasses(this.children, superName);
        for (String implementedInterface : interfaces) {
            this.addSignatureToClasses(this.children, implementedInterface);
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.addSignatureToClasses(this.children, descriptor);
        return this.methodVisitor;
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        this.addSignatureToClasses(this.children, descriptor);
        String cname = descriptor.replace("/", ".");
        if (this.className.equals(this.endPoint.name) && cname.contains(Route.class.getName())) {
            return this.routeVisitor;
        }
        if (cname.contains(JsModule.class.getName())) {
            return this.jsModuleVisitor;
        }
        if (cname.contains(JavaScript.class.getName())) {
            return this.jScriptVisitor;
        }
        if (cname.contains(NoTheme.class.getName())) {
            if (this.className.equals(this.endPoint.name)) {
                this.endPoint.theme.notheme = true;
            }
            return null;
        }
        if (cname.contains(Theme.class.getName())) {
            if (this.className.equals(this.endPoint.name)) {
                return this.themeRouteVisitor;
            }
            if (this.className.equals(this.endPoint.layout)) {
                return this.themeLayoutVisitor;
            }
        }
        if (cname.contains(CssImport.class.getName())) {
            return new CssAnnotationVisitor(this.endPoint.css);
        }
        return this.annotationVisitor;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        this.addSignatureToClasses(this.children, descriptor);
        return null;
    }

    public Set<String> getChildren() {
        return this.children;
    }

    void addSignatureToClasses(Set<String> classes, String signature) {
        if (signature == null || signature.isEmpty()) {
            return;
        }
        String[] tmp = signature.replace("/", ".").split("(^\\([\\[ZBFDJICL]*|^[\\[ZBFDJICL]+|;?\\)[\\[ZBFDJICLV]*|;[\\[ZBFDJICL]*)");
        classes.addAll(Arrays.asList(tmp));
    }

    private final class FrontendMethodVisitor
    extends MethodVisitor {
        public FrontendMethodVisitor() {
            super(524288);
        }

        public void visitTypeInsn(int opcode, String type) {
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, type);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, owner);
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, descriptor);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, owner);
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, descriptor);
        }

        public void visitLdcInsn(Object value) {
            if (value instanceof Type) {
                FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, value.toString());
            }
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, descriptor);
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, bootstrapMethodHandle.getOwner());
            FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, bootstrapMethodHandle.getDesc());
            for (Object obj : bootstrapMethodArguments) {
                if (obj instanceof Type) {
                    FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, obj.toString());
                    continue;
                }
                if (!(obj instanceof Handle)) continue;
                FrontendClassVisitor.this.addSignatureToClasses(FrontendClassVisitor.this.children, ((Handle)obj).getOwner());
            }
        }
    }
}

