/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class TaskGenerateBootstrap
extends AbstractTaskClientGenerator {
    static final String DEVMODE_GIZMO_IMPORT = String.format("import '@vaadin/flow-frontend/VaadinDevmodeGizmo.js';%n", new Object[0]);
    private final FrontendDependenciesScanner frontDeps;
    private final File frontendGeneratedDirectory;
    private final File frontendDirectory;
    private boolean productionMode;

    TaskGenerateBootstrap(FrontendDependenciesScanner frontDeps, File frontendDirectory, boolean productionMode) {
        this.frontDeps = frontDeps;
        this.frontendDirectory = frontendDirectory;
        this.productionMode = productionMode;
        this.frontendGeneratedDirectory = new File(frontendDirectory, "generated/");
    }

    @Override
    protected String getFileContent() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format("import '%s';%n", this.getIndexTsEntryPath()));
        if (!this.productionMode) {
            lines.add(DEVMODE_GIZMO_IMPORT);
        }
        lines.addAll(this.getThemeLines());
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.frontendGeneratedDirectory, "vaadin.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        return this.frontDeps != null;
    }

    private String getIndexTsEntryPath() {
        boolean hasCustomIndexFile;
        boolean bl = hasCustomIndexFile = new File(this.frontendDirectory, "index.ts").exists() || new File(this.frontendDirectory, "index.js").exists();
        if (hasCustomIndexFile) {
            return "../index";
        }
        return "./index";
    }

    private Collection<String> getThemeLines() {
        ArrayList<String> lines = new ArrayList<String>();
        if (this.shouldApplyAppTheme()) {
            lines.add("import { applyTheme } from './theme';");
            lines.add("applyTheme(document);");
            lines.add("");
        }
        return lines;
    }

    private boolean shouldApplyAppTheme() {
        ThemeDefinition themeDef = this.frontDeps.getThemeDefinition();
        return themeDef != null && !"".equals(themeDef.getName());
    }
}

