/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.NodeTasks;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUpdateSettingsFile
implements FallibleCommand,
Serializable {
    public static final String DEV_SETTINGS_FILE = "vaadin-dev-server-settings.json";
    File npmFolder;
    File frontendDirectory;
    File flowResourcesFolder;
    File webappResourcesDirectory;
    String buildDirectory;
    String themeName;
    PwaConfiguration pwaConfiguration;

    TaskUpdateSettingsFile(NodeTasks.Builder builder, String themeName, PwaConfiguration pwaConfiguration) {
        this.npmFolder = builder.getNpmFolder();
        this.frontendDirectory = builder.getFrontendDirectory();
        this.flowResourcesFolder = builder.getFlowResourcesFolder();
        this.webappResourcesDirectory = builder.getWebappResourcesDirectory();
        this.buildDirectory = builder.getBuildDirectory();
        this.themeName = themeName;
        this.pwaConfiguration = pwaConfiguration;
    }

    @Override
    public void execute() {
        if (this.npmFolder == null) {
            return;
        }
        JsonObject settings = Json.createObject();
        settings.put("frontendFolder", FrontendUtils.getUnixPath(this.frontendDirectory.toPath()));
        settings.put("themeFolder", "themes");
        settings.put("themeResourceFolder", FrontendUtils.getUnixPath(this.flowResourcesFolder.toPath()));
        String webappResources = this.webappResourcesDirectory == null ? this.combinePath(this.buildDirectory, "classes", "META-INF/VAADIN/webapp/") : this.webappResourcesDirectory.getPath();
        String staticOutput = this.combinePath(webappResources, "VAADIN/static/");
        settings.put("staticOutput", FrontendUtils.getUnixPath(new File(staticOutput).toPath()));
        settings.put("generatedFolder", "generated");
        settings.put("frontendBundleOutput", webappResources);
        settings.put("addonFrontendFolder", this.combinePath(this.buildDirectory, "flow-frontend"));
        settings.put("themeName", this.themeName);
        settings.put("clientServiceWorkerSource", this.getServiceWorkerFile());
        settings.put("pwaEnabled", this.pwaConfiguration.isEnabled());
        settings.put("offlinePath", this.getOfflinePath());
        File settingsFile = new File(this.npmFolder, this.buildDirectory + "/" + DEV_SETTINGS_FILE);
        try {
            FileUtils.write((File)settingsFile, (CharSequence)JsonUtil.stringify((JsonValue)settings, (int)2), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.log().error("Failed to write file: {}", (Object)settingsFile, (Object)e);
        }
    }

    private String combinePath(String ... parts) {
        StringBuilder path = new StringBuilder();
        for (String part : parts) {
            path.append(part);
            if (part.endsWith("/")) continue;
            path.append('/');
        }
        return path.toString();
    }

    private String getServiceWorkerFile() {
        boolean exists = new File(this.frontendDirectory, "sw.ts").exists() || new File(this.frontendDirectory, "sw.js").exists();
        String serviceWorkerFile = "sw.ts";
        if (new File(this.frontendDirectory, "sw.js").exists()) {
            serviceWorkerFile = "sw.js";
        }
        if (!exists) {
            Path path = Paths.get(this.npmFolder.toString(), this.buildDirectory, serviceWorkerFile);
            return path.toString();
        }
        return Paths.get(this.frontendDirectory.toString(), serviceWorkerFile).toString();
    }

    private String getOfflinePath() {
        if (this.pwaConfiguration.isOfflinePathEnabled()) {
            return "'" + this.getEscapedRelativePath(Paths.get(this.pwaConfiguration.getOfflinePath(), new String[0])) + "'";
        }
        return "'.'";
    }

    private String getEscapedRelativePath(Path path) {
        if (path.isAbsolute()) {
            return FrontendUtils.getUnixRelativePath(this.npmFolder.toPath(), path);
        }
        return FrontendUtils.getUnixPath(path);
    }

    private Logger log() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

