/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.NullOwner;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.change.NodeAttachChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.change.NodeDetachChange;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.NodeFeatureRegistry;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StateNode
implements Serializable {
    private static final ReplacedViaPreserveOnRefresh REPLACED_MARKER = new ReplacedViaPreserveOnRefresh();
    private static final Map<FeatureSetKey, FeatureSet> featureSetCache = new ConcurrentHashMap<FeatureSetKey, FeatureSet>();
    private final FeatureSet featureSet;
    private Serializable features;
    private Map<Class<? extends NodeFeature>, Serializable> changes;
    private List<Command> attachListeners;
    private List<Command> detachListeners;
    private NodeOwner owner = NullOwner.get();
    private StateNode parent;
    private int id = -1;
    private boolean wasAttached = this.isAttached();
    private boolean hasBeenAttached;
    private boolean hasBeenDetached;
    private boolean isInactiveSelf;
    private boolean isInitialChanges = true;
    private ArrayList<StateTree.BeforeClientResponseEntry> beforeClientResponseEntries;
    private boolean enabled = true;

    @SafeVarargs
    public StateNode(Class<? extends NodeFeature> ... featureTypes) {
        this(Collections.emptyList(), featureTypes);
    }

    public StateNode(StateNode node) {
        this(new ArrayList<Class<? extends NodeFeature>>(node.featureSet.reportedFeatures), StateNode.getNonRepeatebleFeatures(node));
    }

    @SafeVarargs
    public StateNode(List<Class<? extends NodeFeature>> reportableFeatureTypes, Class<? extends NodeFeature> ... additionalFeatureTypes) {
        this.featureSet = featureSetCache.computeIfAbsent(new FeatureSetKey(reportableFeatureTypes, additionalFeatureTypes), FeatureSet::new);
        this.features = null;
        reportableFeatureTypes.forEach(this::getFeature);
    }

    public NodeOwner getOwner() {
        return this.owner;
    }

    public StateNode getParent() {
        return this.parent;
    }

    public void setParent(StateNode parent) {
        if (this.hasDetached()) {
            return;
        }
        boolean attachedBefore = this.isRegistered();
        boolean attachedAfter = false;
        if (parent != null) {
            assert (this.parent == null) : "Node is already attached to a parent: " + this.parent;
            assert (parent.hasChildAssert(this));
            if (this.isAncestorOf(parent)) {
                throw new IllegalStateException("Can't set own child as parent");
            }
            attachedAfter = parent.isRegistered();
            NodeOwner parentOwner = parent.getOwner();
            if (parentOwner != this.owner && parentOwner instanceof StateTree) {
                this.setTree((StateTree)parentOwner);
            }
        }
        if (!attachedBefore && attachedAfter) {
            this.parent = parent;
            this.onAttach();
        } else if (attachedBefore && !attachedAfter) {
            this.onDetach();
            this.parent = parent;
        } else {
            this.parent = parent;
        }
    }

    private boolean hasDetached() {
        return this.isAttached() && !this.owner.hasNode(this);
    }

    private boolean isAncestorOf(StateNode node) {
        while (node != null) {
            if (node == this) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private boolean hasChildAssert(StateNode child) {
        AtomicBoolean found = new AtomicBoolean(false);
        this.forEachChild(c -> {
            if (c == child) {
                found.set(true);
            }
        });
        return found.get();
    }

    protected void onAttach() {
        ArrayList attachedNodes = new ArrayList();
        this.visitNodeTreeBottomUp(node -> attachedNodes.add(new Pair<StateNode, Boolean>((StateNode)node, node.handleOnAttach())));
        for (Pair pair : attachedNodes) {
            boolean isInitial = (Boolean)pair.getSecond();
            StateNode node2 = (StateNode)pair.getFirst();
            if (!node2.isRegistered() || !isInitial && !node2.hasBeenDetached) continue;
            node2.hasBeenAttached = true;
            node2.fireAttachListeners(isInitial);
        }
    }

    private void onDetach() {
        ArrayList nodes = new ArrayList();
        this.visitNodeTreeBottomUp(nodes::add);
        nodes.forEach(StateNode::handleOnDetach);
        for (StateNode node : nodes) {
            if (!node.hasBeenAttached) continue;
            node.hasBeenDetached = true;
            node.fireDetachListeners();
        }
    }

    private void forEachChild(Consumer<StateNode> action) {
        this.forEachFeature(n -> n.forEachChild(action));
    }

    private void forEachFeature(Consumer<NodeFeature> action) {
        this.getInitializedFeatures().forEach(action::accept);
    }

    private Stream<NodeFeature> getInitializedFeatures() {
        if (this.features == null) {
            return Stream.empty();
        }
        if (this.features instanceof NodeFeature) {
            return Stream.of((NodeFeature)this.features);
        }
        return Stream.of((NodeFeature[])this.features).filter(Objects::nonNull);
    }

    protected void setTree(StateTree tree) {
        this.visitNodeTree(node -> node.doSetTree(tree));
    }

    public void removeFromTree() {
        if (this.getOwner() instanceof StateTree) {
            ComponentUtil.setData((Component)((StateTree)this.getOwner()).getUI(), ReplacedViaPreserveOnRefresh.class, REPLACED_MARKER);
        }
        this.visitNodeTree(StateNode::reset);
        this.setParent(null);
    }

    private void reset() {
        this.owner = NullOwner.get();
        this.id = -1;
        this.wasAttached = false;
        this.hasBeenAttached = false;
        this.hasBeenDetached = false;
    }

    protected void prepareForResync() {
        this.visitNodeTreeBottomUp(StateNode::fireDetachListeners);
        this.visitNodeTree(stateNode -> {
            this.getOwner().markAsDirty((StateNode)stateNode);
            stateNode.wasAttached = false;
            stateNode.isInitialChanges = true;
            stateNode.hasBeenAttached = false;
            stateNode.hasBeenDetached = false;
        });
        this.visitNodeTreeBottomUp(sn -> sn.fireAttachListeners(true));
    }

    public <T extends NodeFeature> T getFeature(Class<T> featureType) {
        NodeFeature feature;
        int featureIndex = this.getFeatureIndex(featureType);
        if (featureIndex == 0 && this.features instanceof NodeFeature) {
            feature = (NodeFeature)this.features;
        } else if (featureIndex == 0 && this.features == null) {
            feature = NodeFeatureRegistry.create(featureType, this);
            this.features = feature;
        } else {
            NodeFeature[] featuresArray;
            if (this.features instanceof NodeFeature[]) {
                featuresArray = (NodeFeature[])this.features;
            } else {
                assert (this.features == null || this.features instanceof NodeFeature);
                featuresArray = new NodeFeature[featureIndex + 1];
                if (this.features instanceof NodeFeature) {
                    featuresArray[0] = (NodeFeature)this.features;
                }
                this.features = featuresArray;
            }
            if (featureIndex >= featuresArray.length) {
                this.features = featuresArray = Arrays.copyOf(featuresArray, featureIndex + 1);
            }
            if ((feature = featuresArray[featureIndex]) == null) {
                featuresArray[featureIndex] = feature = NodeFeatureRegistry.create(featureType, this);
            }
        }
        return (T)((NodeFeature)featureType.cast(feature));
    }

    private <T extends NodeFeature> int getFeatureIndex(Class<T> featureType) {
        assert (featureType != null);
        Integer featureIndex = (Integer)this.featureSet.mappings.get(featureType);
        if (featureIndex == null) {
            throw new IllegalStateException("Node does not have the feature " + featureType);
        }
        return featureIndex;
    }

    public <T extends NodeFeature> Optional<T> getFeatureIfInitialized(Class<T> featureType) {
        if (this.features == null) {
            return Optional.empty();
        }
        int featureIndex = this.getFeatureIndex(featureType);
        if (this.features instanceof NodeFeature) {
            if (featureIndex == 0) {
                return Optional.of(featureType.cast(this.features));
            }
            return Optional.empty();
        }
        NodeFeature[] featuresArray = (NodeFeature[])this.features;
        if (featureIndex >= featuresArray.length) {
            return Optional.empty();
        }
        return Optional.ofNullable(featuresArray[featureIndex]).map(featureType::cast);
    }

    public boolean hasFeature(Class<? extends NodeFeature> featureType) {
        assert (featureType != null);
        return this.featureSet.mappings.containsKey(featureType);
    }

    public int getId() {
        return this.id;
    }

    public void markAsDirty() {
        this.owner.markAsDirty(this);
    }

    public boolean isAttached() {
        if (this.getParent() == null) {
            return false;
        }
        StateNode root = this.getParent();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root.isAttached();
    }

    boolean isClientSideInitialized() {
        return this.wasAttached;
    }

    public void collectChanges(Consumer<NodeChange> collector) {
        boolean isAttached = this.isAttached();
        if (isAttached != this.wasAttached) {
            if (isAttached) {
                collector.accept(new NodeAttachChange(this));
                this.clearChanges();
                this.forEachFeature(NodeFeature::generateChangesFromEmpty);
            } else {
                collector.accept(new NodeDetachChange(this));
            }
            this.wasAttached = isAttached;
        }
        if (!this.isAttached()) {
            return;
        }
        if (this.isInactive()) {
            if (this.isInitialChanges) {
                Stream<NodeFeature> initialFeatures = Stream.concat(this.featureSet.mappings.keySet().stream().filter(this::isReportedFeature).map(this::getFeature), this.getDisalowFeatures());
                this.doCollectChanges(collector, initialFeatures);
            } else {
                this.doCollectChanges(collector, this.getDisalowFeatures());
            }
        } else {
            this.doCollectChanges(collector, this.getInitializedFeatures());
        }
    }

    private void doCollectChanges(Consumer<NodeChange> collector, Stream<NodeFeature> features) {
        features.filter(this::hasChangeTracker).forEach(feature -> {
            feature.collectChanges(collector);
            this.changes.remove(feature.getClass());
        });
        this.isInitialChanges = false;
        if (this.changes != null && this.changes.isEmpty()) {
            this.changes = null;
        }
    }

    private boolean hasChangeTracker(NodeFeature nodeFeature) {
        return this.changes != null && this.changes.containsKey(nodeFeature.getClass());
    }

    public void clearChanges() {
        this.changes = null;
    }

    public void visitNodeTree(Consumer<StateNode> visitor) {
        LinkedList<StateNode> stack = new LinkedList<StateNode>();
        stack.add(this);
        while (!stack.isEmpty()) {
            StateNode node = (StateNode)stack.removeFirst();
            visitor.accept(node);
            node.forEachChild(child -> stack.add(0, (StateNode)child));
        }
    }

    void visitNodeTreeBottomUp(Consumer<StateNode> visitor) {
        LinkedList<StateNode> stack = new LinkedList<StateNode>();
        stack.add(this);
        this.forEachChild(stack::addFirst);
        StateNode previousParent = this;
        while (!stack.isEmpty()) {
            StateNode current = (StateNode)stack.getFirst();
            assert (current != null);
            if (current == previousParent) {
                visitor.accept((StateNode)stack.removeFirst());
                previousParent = current.getParent();
                continue;
            }
            current.forEachChild(stack::addFirst);
            previousParent = current;
        }
    }

    private void doSetTree(StateTree tree) {
        if (tree == this.getOwner()) {
            return;
        }
        if (this.getOwner() instanceof StateTree) {
            boolean isNotReplaced;
            boolean isOwnerAttached = ((StateTree)this.getOwner()).getRootNode().isAttached();
            boolean bl = isNotReplaced = ComponentUtil.getData((Component)((StateTree)this.getOwner()).getUI(), ReplacedViaPreserveOnRefresh.class) == null;
            if (isOwnerAttached || isNotReplaced) {
                throw new IllegalStateException("Can't move a node from one state tree to another. If this is intentional, first remove the node from its current state tree by calling removeFromTree");
            }
            this.id = -1;
        }
        this.owner = tree;
    }

    private boolean handleOnAttach() {
        assert (this.isAttached());
        boolean initialAttach = false;
        int newId = this.owner.register(this);
        if (newId != -1) {
            if (this.id == -1) {
                this.id = newId;
                initialAttach = true;
            } else if (newId != this.id) {
                throw new IllegalStateException("Can't change id once it has been assigned");
            }
        }
        this.markAsDirty();
        return initialAttach;
    }

    private void handleOnDetach() {
        assert (this.isAttached());
        this.markAsDirty();
        this.owner.unregister(this);
    }

    public Registration addAttachListener(Command attachListener) {
        assert (attachListener != null);
        if (this.attachListeners == null) {
            this.attachListeners = new ArrayList<Command>(1);
        }
        this.attachListeners.add(attachListener);
        return () -> this.removeAttachListener(attachListener);
    }

    public Registration addDetachListener(Command detachListener) {
        assert (detachListener != null);
        if (this.detachListeners == null) {
            this.detachListeners = new ArrayList<Command>(1);
        }
        this.detachListeners.add(detachListener);
        return () -> this.removeDetachListener(detachListener);
    }

    private void removeAttachListener(Command attachListener) {
        assert (attachListener != null);
        this.attachListeners.remove(attachListener);
        if (this.attachListeners.isEmpty()) {
            this.attachListeners = null;
        }
    }

    private void removeDetachListener(Command detachListener) {
        assert (detachListener != null);
        this.detachListeners.remove(detachListener);
        if (this.detachListeners.isEmpty()) {
            this.detachListeners = null;
        }
    }

    private void fireAttachListeners(boolean initialAttach) {
        if (this.attachListeners != null) {
            ArrayList<Command> copy = new ArrayList<Command>(this.attachListeners);
            copy.forEach(Command::execute);
        }
        this.forEachFeature(f -> f.onAttach(initialAttach));
    }

    private void fireDetachListeners() {
        if (this.detachListeners != null) {
            ArrayList<Command> copy = new ArrayList<Command>(this.detachListeners);
            copy.forEach(Command::execute);
        }
        this.forEachFeature(NodeFeature::onDetach);
    }

    public <T extends Serializable> T getChangeTracker(NodeFeature feature, Supplier<T> factory) {
        if (this.changes == null) {
            this.changes = new HashMap<Class<? extends NodeFeature>, Serializable>();
        }
        return (T)this.changes.computeIfAbsent(feature.getClass(), k -> (Serializable)factory.get());
    }

    public void runWhenAttached(final SerializableConsumer<UI> command) {
        if (this.isAttached()) {
            command.accept(this.getUI());
        } else {
            this.addAttachListener(new Command(){

                @Override
                public void execute() {
                    command.accept(StateNode.this.getUI());
                    StateNode.this.removeAttachListener(this);
                }
            });
        }
    }

    public boolean isReportedFeature(Class<? extends NodeFeature> featureType) {
        return this.featureSet.reportedFeatures.contains(featureType);
    }

    public void updateActiveState() {
        this.setInactive(this.getDisalowFeatures().count() != 0L);
    }

    public boolean isInactive() {
        if (this.isInactiveSelf || this.getParent() == null) {
            return this.isInactiveSelf;
        }
        return this.getParent().isInactive();
    }

    private Stream<NodeFeature> getDisalowFeatures() {
        return this.getInitializedFeatures().filter(feature -> !feature.allowsChanges());
    }

    private void setInactive(boolean inactive) {
        if (this.isInactiveSelf != inactive) {
            this.isInactiveSelf = inactive;
            this.visitNodeTree(child -> {
                if (!this.equals(child) && !child.isInactiveSelf) {
                    child.markAsDirty();
                }
            });
        }
    }

    private UI getUI() {
        assert (this.isAttached());
        assert (this.getOwner() instanceof StateTree) : "Attach should only be called when the node has been attached to the tree, not to a null owner";
        return ((StateTree)this.getOwner()).getUI();
    }

    private static Class[] getNonRepeatebleFeatures(StateNode node) {
        if (node.featureSet.reportedFeatures.isEmpty()) {
            Set set = node.featureSet.mappings.keySet();
            return set.toArray(new Class[set.size()]);
        }
        return (Class[])node.featureSet.mappings.keySet().stream().filter(clazz -> !node.featureSet.reportedFeatures.contains(clazz)).toArray(Class[]::new);
    }

    public boolean hasBeforeClientResponseEntries() {
        return this.beforeClientResponseEntries != null;
    }

    public List<StateTree.BeforeClientResponseEntry> dumpBeforeClientResponseEntries() {
        ArrayList<StateTree.BeforeClientResponseEntry> entries = this.beforeClientResponseEntries;
        this.beforeClientResponseEntries = null;
        return !entries.isEmpty() ? entries : Collections.emptyList();
    }

    public StateTree.ExecutionRegistration addBeforeClientResponseEntry(StateTree.BeforeClientResponseEntry entry) {
        assert (entry != null);
        if (this.beforeClientResponseEntries == null) {
            this.beforeClientResponseEntries = new ArrayList();
        }
        ArrayList<StateTree.BeforeClientResponseEntry> localEntries = this.beforeClientResponseEntries;
        localEntries.add(entry);
        return () -> localEntries.remove(entry);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        boolean isEnabledSelf = this.isEnabledSelf();
        if (this.getParent() != null && isEnabledSelf) {
            return this.getParent().isEnabled();
        }
        return isEnabledSelf;
    }

    public boolean isEnabledSelf() {
        return this.enabled;
    }

    private boolean isRegistered() {
        return this.isAttached() && this.getOwner().hasNode(this);
    }

    private static class ReplacedViaPreserveOnRefresh
    implements Serializable {
        private ReplacedViaPreserveOnRefresh() {
        }
    }

    private static class FeatureSet
    implements Serializable {
        private final Set<Class<? extends NodeFeature>> reportedFeatures;
        private final Map<Class<? extends NodeFeature>, Integer> mappings = new HashMap<Class<? extends NodeFeature>, Integer>();

        public FeatureSet(FeatureSetKey featureSetKey) {
            this.reportedFeatures = featureSetKey.reportedFeatures;
            featureSetKey.getAllFeatures().sorted(NodeFeatureRegistry.PRIORITY_COMPARATOR).forEach(key -> this.mappings.put((Class<? extends NodeFeature>)key, this.mappings.size()));
        }
    }

    private static class FeatureSetKey
    implements Serializable {
        private final Set<Class<? extends NodeFeature>> reportedFeatures;
        private final Set<Class<? extends NodeFeature>> nonReportableFeatures;

        public FeatureSetKey(Collection<Class<? extends NodeFeature>> reportableFeatureTypes, Class<? extends NodeFeature>[] additionalFeatureTypes) {
            this.reportedFeatures = new HashSet<Class<? extends NodeFeature>>(reportableFeatureTypes);
            this.nonReportableFeatures = Stream.of(additionalFeatureTypes).filter(type -> !reportableFeatureTypes.contains(type)).collect(Collectors.toSet());
            assert (!this.nonReportableFeatures.removeAll(this.reportedFeatures)) : "No reportable feature should also be non-reportable";
            assert (!this.reportedFeatures.removeAll(this.nonReportableFeatures)) : "No non-reportable feature should also be reportable";
        }

        public int hashCode() {
            return Objects.hash(this.reportedFeatures, this.nonReportableFeatures);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof FeatureSetKey) {
                FeatureSetKey that = (FeatureSetKey)obj;
                return that.nonReportableFeatures.equals(this.nonReportableFeatures) && that.reportedFeatures.equals(this.reportedFeatures);
            }
            return false;
        }

        public Stream<Class<? extends NodeFeature>> getAllFeatures() {
            return Stream.concat(this.nonReportableFeatures.stream(), this.reportedFeatures.stream());
        }
    }
}

