package com.vaadin.uitest.ai.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeysUtils {

    private static final Logger LOGGER = LoggerFactory
            .getLogger(KeysUtils.class);
    private static String OPEN_AI_KEY;
    private static String PINECONE_API_KEY;
    private static String PINECONE_API_URL;

    static {
        OPEN_AI_KEY = System.getProperty("OPENAI_TOKEN");
        if (OPEN_AI_KEY == null || OPEN_AI_KEY.isBlank()) {
            OPEN_AI_KEY = System.getenv("OPENAI_TOKEN");
        }
        PINECONE_API_KEY = System.getProperty("PINECONE_API_KEY");
        if (PINECONE_API_KEY == null || PINECONE_API_KEY.isBlank()) {
            PINECONE_API_KEY = System.getenv("PINECONE_API_KEY");
        }
        PINECONE_API_URL = System.getProperty("PINECONE_API_URL");
        if (PINECONE_API_URL == null || PINECONE_API_URL.isBlank()) {
            PINECONE_API_URL = System.getenv("PINECONE_API_URL");
        }
        if (OPEN_AI_KEY != null && !OPEN_AI_KEY.isBlank()) {
            LOGGER.debug("OPEN_AI_KEY initialized");
        } else {
            LOGGER.error("OPENAI_TOKEN was not filled properly");
        }
        if (PINECONE_API_KEY != null && !PINECONE_API_KEY.isBlank()) {
            LOGGER.debug("PINECONE_API_KEY initialized");
        } else {
            LOGGER.debug("PINECONE_API_KEY was not filled properly");
        }
        if (PINECONE_API_URL != null && !PINECONE_API_URL.isBlank()) {
            LOGGER.debug("PINECONE_API_URL initialized");
        } else {
            LOGGER.debug("PINECONE_API_URL was not filled properly");
        }
        setKeys(OPEN_AI_KEY, PINECONE_API_KEY, PINECONE_API_URL);
    }

    public static String getOpenAiKey() {
        if (OPEN_AI_KEY == null || OPEN_AI_KEY.isBlank()) {
            LOGGER.error("OPENAI_TOKEN was not filled properly");
        }
        return OPEN_AI_KEY;
    }

    public static String getPineconeKey() {
        if (PINECONE_API_KEY == null || PINECONE_API_KEY.isBlank()) {
            LOGGER.debug("PINECONE_API_KEY was not filled properly");
        }
        return PINECONE_API_KEY;
    }

    public static String getPineconeUrl() {
        if (PINECONE_API_URL != null && PINECONE_API_URL.isBlank()) {
            LOGGER.debug("PINECONE_API_URL was not filled properly");
        }
        return PINECONE_API_URL;
    }

    public static void setKeys(String aikey, String pinekey, String pineurl) {
        if (aikey != null && pinekey != null && pineurl != null
                && aikey.equals(OPEN_AI_KEY) && pinekey.equals(PINECONE_API_KEY)
                && pineurl.equals(PINECONE_API_URL)) {
            return;
        }
        LOGGER.debug("KEYS updated programmatically");
        OPEN_AI_KEY = aikey;
        PINECONE_API_KEY = pinekey;
        PINECONE_API_URL = pineurl;
    }
}