package com.vaadin.uitest.model;

import java.util.Arrays;

public enum Framework {

    FLOW("Vaadin Flow", "flow", TestFramework.PLAYWRIGHT_JAVA),

    LIT("Vaadin Hilla (Lit)", "lit", TestFramework.PLAYWRIGHT_NODE),

    REACT("Vaadin Hilla (React)", "react", TestFramework.PLAYWRIGHT_NODE);

    private final String label;
    private final String value;
    private final TestFramework defaultTestFramework;

    Framework(String label, String value, TestFramework defaultTestFramework) {
        this.label = label;
        this.value = value;
        this.defaultTestFramework = defaultTestFramework;
    }

    public String getLabel() {
        return label;
    }

    public String getValue() {
        return value;
    }

    public TestFramework getDefaultTestFramework() {
        return defaultTestFramework;
    }

    public static Framework getByValue(String frameworkValue) {
        return Arrays.stream(values()).filter(
                framework -> framework.getValue().equals(frameworkValue))
                .findAny().orElse(null);
    }

    public static Framework getByLabel(String label) {
        return Arrays.stream(values())
                .filter(framework -> framework.getLabel().equals(label))
                .findAny().orElse(null);
    }
}
