/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.spring.springnative;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.PWA;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;

public class VaadinBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            this.findAndRegisterRoutes((BeanDefinitionRegistry)beanFactory);
        } else {
            this.logger.error("Unable to register @Route classes as beans because the used bean factory is of type {} which does not implement {}", (Object)beanFactory.getClass().getName(), (Object)BeanDefinitionRegistry.class.getName());
        }
        return (generationContext, beanFactoryInitializationCode) -> {
            RuntimeHints hints = generationContext.getRuntimeHints();
            for (String pkg : VaadinBeanFactoryInitializationAotProcessor.getPackages((BeanFactory)beanFactory)) {
                Reflections reflections = new Reflections(pkg, new Scanner[0]);
                for (Class<?> c : VaadinBeanFactoryInitializationAotProcessor.getRouteTypesFor(reflections, pkg)) {
                    this.registerType(hints, c);
                    this.registerResources(hints, c);
                }
                boolean hasPWA = false;
                for (Class c : reflections.getSubTypesOf(AppShellConfigurator.class)) {
                    this.registerType(hints, c);
                    this.registerResources(hints, c);
                    hasPWA = hasPWA || c.getAnnotation(PWA.class) != null;
                }
                if (hasPWA) {
                    for (String cls : VaadinBeanFactoryInitializationAotProcessor.getJNIClassesForPWA()) {
                        hints.jni().registerType(TypeReference.of((String)cls), MemberCategory.values());
                    }
                }
                this.registerSubTypes(hints, reflections, Component.class);
                this.registerSubTypes(hints, reflections, RouterLayout.class);
                this.registerSubTypes(hints, reflections, HasErrorParameter.class);
                this.registerSubTypes(hints, reflections, ComponentEvent.class);
                this.registerSubTypes(hints, reflections, HasUrlParameter.class);
                this.registerSubTypes(hints, reflections, "com.vaadin.flow.data.converter.Converter");
            }
        };
    }

    private void registerSubTypes(RuntimeHints hints, Reflections reflections, Class<?> cls) {
        for (Class c : reflections.getSubTypesOf(cls)) {
            this.registerType(hints, c);
        }
    }

    private void registerSubTypes(RuntimeHints hints, Reflections reflections, String className) {
        try {
            Class<?> cls = Class.forName(className);
            for (Class c : reflections.getSubTypesOf(cls)) {
                this.registerType(hints, c);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    private static List<String> getPackagesWithRoutes(BeanFactory beanFactory) {
        ArrayList<String> packages = new ArrayList<String>();
        packages.add("com.vaadin");
        packages.addAll(AutoConfigurationPackages.get((BeanFactory)beanFactory));
        return packages;
    }

    private <T extends BeanFactory & BeanDefinitionRegistry> void findAndRegisterRoutes(T beanFactory) {
        String markerBeanName = Marker.class.getName();
        this.logger.debug("Finding and registering routes");
        if (((BeanDefinitionRegistry)beanFactory).containsBeanDefinition(markerBeanName)) {
            this.logger.debug("Routes already registered");
            return;
        }
        HashSet<String> registeredClasses = new HashSet<String>();
        for (String beanName : ((BeanDefinitionRegistry)beanFactory).getBeanDefinitionNames()) {
            BeanDefinition def = ((BeanDefinitionRegistry)beanFactory).getBeanDefinition(beanName);
            if (def.getBeanClassName() == null) continue;
            registeredClasses.add(def.getBeanClassName());
        }
        for (String pkg : VaadinBeanFactoryInitializationAotProcessor.getPackagesWithRoutes(beanFactory)) {
            this.logger.debug("Scanning for @{} or @{} annotated beans in {}", new Object[]{Route.class.getSimpleName(), RouteAlias.class.getSimpleName(), pkg});
            Reflections reflections = new Reflections(pkg, new Scanner[0]);
            for (Class<?> c : VaadinBeanFactoryInitializationAotProcessor.getRouteTypesFor(reflections, pkg)) {
                if (registeredClasses.contains(c.getName())) {
                    this.logger.debug("Skipping route class {} as it has already been registered as a bean", (Object)c.getName());
                    continue;
                }
                registeredClasses.add(c.getName());
                this.logger.debug("Registering a bean for route class {}", (Object)c.getName());
                AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(c).setScope("prototype").getBeanDefinition();
                ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(c.getName(), (BeanDefinition)beanDefinition);
            }
        }
        ((BeanDefinitionRegistry)beanFactory).registerBeanDefinition(markerBeanName, (BeanDefinition)BeanDefinitionBuilder.rootBeanDefinition(Marker.class).getBeanDefinition());
    }

    private static Collection<Class<?>> getRouteTypesFor(Reflections reflections, String packageName) {
        HashSet routeTypes = new HashSet();
        routeTypes.addAll(reflections.getTypesAnnotatedWith(Route.class));
        routeTypes.addAll(reflections.getTypesAnnotatedWith(RouteAlias.class));
        return routeTypes;
    }

    private void registerResources(RuntimeHints hints, Class<?> c) {
        if (c.getCanonicalName() == null) {
            return;
        }
        hints.resources().registerType(c);
    }

    private void registerType(RuntimeHints hints, Class<?> c) {
        if (c.getCanonicalName() == null) {
            return;
        }
        MemberCategory[] memberCategories = MemberCategory.values();
        hints.reflection().registerType(c, memberCategories);
    }

    private static List<String> getPackages(BeanFactory beanFactory) {
        ArrayList<String> listOf = new ArrayList<String>();
        listOf.add("com.vaadin");
        listOf.addAll(AutoConfigurationPackages.get((BeanFactory)beanFactory));
        return listOf;
    }

    private static String[] getJNIClassesForPWA() {
        return new String[]{"com.sun.imageio.plugins.jpeg.JPEGImageReader", "com.sun.imageio.plugins.jpeg.JPEGImageWriter", "java.awt.AlphaComposite", "java.awt.Color", "java.awt.color.CMMException", "java.awt.color.ColorSpace", "java.awt.color.ICC_ColorSpace", "java.awt.color.ICC_Profile", "java.awt.color.ICC_ProfileGray", "java.awt.color.ICC_ProfileRGB", "java.awt.Composite", "java.awt.geom.AffineTransform", "java.awt.geom.GeneralPath", "java.awt.geom.Path2D", "java.awt.geom.Path2D$Float", "java.awt.geom.Point2D$Float", "java.awt.geom.Rectangle2D$Float", "java.awt.image.AffineTransformOp", "java.awt.image.BandedSampleModel", "java.awt.image.BufferedImage", "java.awt.image.ColorModel", "java.awt.image.ComponentColorModel", "java.awt.image.ComponentSampleModel", "java.awt.image.ConvolveOp", "java.awt.image.DirectColorModel", "java.awt.image.IndexColorModel", "java.awt.image.Kernel", "java.awt.image.MultiPixelPackedSampleModel", "java.awt.image.PackedColorModel", "java.awt.image.PixelInterleavedSampleModel", "java.awt.image.Raster", "java.awt.image.SampleModel", "java.awt.image.SinglePixelPackedSampleModel", "java.awt.Insets", "java.awt.Rectangle", "java.awt.Transparency", "java.awt.Toolkit", "javax.imageio.IIOException", "javax.imageio.plugins.jpeg.JPEGHuffmanTable", "javax.imageio.plugins.jpeg.JPEGQTable", "sun.awt.image.BufImgSurfaceData", "sun.awt.image.BufImgSurfaceData$ICMColorData", "sun.awt.image.ByteBandedRaster", "sun.awt.image.ByteComponentRaster", "sun.awt.image.ByteInterleavedRaster", "sun.awt.image.BytePackedRaster", "sun.awt.image.DataBufferNative", "sun.awt.image.GifImageDecoder", "sun.awt.image.ImageRepresentation", "sun.awt.image.ImagingLib", "sun.awt.image.IntegerComponentRaster", "sun.awt.image.IntegerInterleavedRaster", "sun.awt.image.ShortBandedRaster", "sun.awt.image.ShortComponentRaster", "sun.awt.image.ShortInterleavedRaster", "sun.awt.image.SunWritableRaster", "sun.awt.image.WritableRasterNative", "sun.awt.SunHints", "sun.font.CharToGlyphMapper", "sun.font.Font2D", "sun.font.FontConfigManager", "sun.font.FontConfigManager$FcCompFont", "sun.font.FontConfigManager$FontConfigFont", "sun.font.FontConfigManager$FontConfigInfo", "sun.font.FontManagerNativeLibrary", "sun.font.FontStrike", "sun.font.FreetypeFontScaler", "sun.font.GlyphLayout", "sun.font.GlyphLayout$EngineRecord", "sun.font.GlyphLayout$GVData", "sun.font.GlyphLayout$LayoutEngine", "sun.font.GlyphLayout$LayoutEngineFactory", "sun.font.GlyphLayout$LayoutEngineKey", "sun.font.GlyphLayout$SDCache", "sun.font.GlyphLayout$SDCache$SDKey", "sun.font.GlyphList", "sun.font.PhysicalStrike", "sun.font.StrikeMetrics", "sun.font.TrueTypeFont", "sun.font.Type1Font", "sun.java2d.cmm.lcms.LCMS", "sun.java2d.cmm.lcms.LCMSImageLayout", "sun.java2d.cmm.lcms.LCMSProfile", "sun.java2d.cmm.lcms.LCMSTransform", "sun.java2d.DefaultDisposerRecord", "sun.java2d.Disposer", "sun.java2d.InvalidPipeException", "sun.java2d.NullSurfaceData", "sun.java2d.SurfaceData", "sun.java2d.loops.Blit", "sun.java2d.loops.BlitBg", "sun.java2d.loops.CompositeType", "sun.java2d.loops.DrawGlyphList", "sun.java2d.loops.DrawGlyphListAA", "sun.java2d.loops.DrawGlyphListLCD", "sun.java2d.loops.DrawLine", "sun.java2d.loops.DrawParallelogram", "sun.java2d.loops.DrawPath", "sun.java2d.loops.DrawPolygons", "sun.java2d.loops.DrawRect", "sun.java2d.loops.FillParallelogram", "sun.java2d.loops.FillPath", "sun.java2d.loops.FillRect", "sun.java2d.loops.FillSpans", "sun.java2d.loops.GraphicsPrimitive", "sun.java2d.loops.GraphicsPrimitiveMgr", "sun.java2d.loops.MaskBlit", "sun.java2d.loops.MaskFill", "sun.java2d.loops.ScaledBlit", "sun.java2d.loops.SurfaceType", "sun.java2d.loops.TransformHelper", "sun.java2d.loops.XORComposite", "sun.java2d.pipe.BufferedMaskBlit", "sun.java2d.pipe.GlyphListPipe", "sun.java2d.pipe.Region", "sun.java2d.pipe.RegionIterator", "sun.java2d.pipe.ShapeSpanIterator", "sun.java2d.pipe.SpanClipRenderer", "sun.java2d.pipe.SpanIterator", "sun.java2d.pipe.ValidatePipe", "sun.java2d.SunGraphics2D"};
    }

    public static class Marker {
    }
}

