/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.textfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.shared.ClientValidationUtil;
import com.vaadin.flow.component.shared.HasAllowedCharPattern;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.component.textfield.TextFieldBase;
import com.vaadin.flow.component.textfield.TextFieldValidationSupport;
import com.vaadin.flow.component.textfield.TextFieldVariant;
import com.vaadin.flow.data.binder.ValidationStatusChangeEvent;
import com.vaadin.flow.data.binder.ValidationStatusChangeListener;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

@Tag(value="vaadin-text-field")
@NpmPackage.Container(value={@NpmPackage(value="@vaadin/polymer-legacy-adapter", version="24.2.0"), @NpmPackage(value="@vaadin/text-field", version="24.2.0")})
@JsModule.Container(value={@JsModule(value="@vaadin/polymer-legacy-adapter/style-modules.js"), @JsModule(value="@vaadin/text-field/src/vaadin-text-field.js")})
public class TextField
extends TextFieldBase<TextField, String>
implements HasAllowedCharPattern,
HasThemeVariant<TextFieldVariant> {
    private boolean isConnectorAttached;
    private TextFieldValidationSupport validationSupport;
    private boolean manualValidationEnabled = false;

    public TextField() {
        this(true);
    }

    private TextField(boolean isInitialValueOptional) {
        super("", "", false, isInitialValueOptional);
        this.setInvalid(false);
        this.setValueChangeMode(ValueChangeMode.ON_CHANGE);
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.validate());
        this.addClientValidatedEventListener((ComponentEventListener & Serializable)e -> this.validate());
    }

    public TextField(String label) {
        this();
        this.setLabel(label);
    }

    public TextField(String label, String placeholder) {
        this(label);
        this.setPlaceholder(placeholder);
    }

    public TextField(String label, String initialValue, String placeholder) {
        this(label);
        this.setValue(initialValue);
        this.setPlaceholder(placeholder);
    }

    public TextField(HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>> listener) {
        this();
        this.addValueChangeListener(listener);
    }

    public TextField(String label, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>> listener) {
        this(label);
        this.addValueChangeListener(listener);
    }

    public TextField(String label, String initialValue, HasValue.ValueChangeListener<? super AbstractField.ComponentValueChangeEvent<TextField, String>> listener) {
        this(label);
        this.setValue(initialValue);
        this.addValueChangeListener(listener);
    }

    private TextFieldValidationSupport getValidationSupport() {
        if (this.validationSupport == null) {
            this.validationSupport = new TextFieldValidationSupport((HasValue<?, String>)this);
        }
        return this.validationSupport;
    }

    public void setMaxLength(int maxLength) {
        this.getElement().setProperty("maxlength", (double)maxLength);
        this.getValidationSupport().setMaxLength(maxLength);
    }

    public int getMaxLength() {
        return (int)this.getElement().getProperty("maxlength", 0.0);
    }

    public void setMinLength(int minLength) {
        this.getElement().setProperty("minlength", (double)minLength);
        this.getValidationSupport().setMinLength(minLength);
    }

    public int getMinLength() {
        return (int)this.getElement().getProperty("minlength", 0.0);
    }

    @Override
    public void setRequired(boolean required) {
        super.setRequired(required);
        this.getValidationSupport().setRequired(required);
    }

    public void setPattern(String pattern) {
        this.getElement().setProperty("pattern", pattern == null ? "" : pattern);
        this.getValidationSupport().setPattern(pattern);
    }

    public String getPattern() {
        return this.getElement().getProperty("pattern");
    }

    public String getEmptyValue() {
        return "";
    }

    public void setValue(String value) {
        super.setValue((Object)value);
    }

    public String getValue() {
        return (String)super.getValue();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        super.setRequiredIndicatorVisible(requiredIndicatorVisible);
        this.getValidationSupport().setRequired(requiredIndicatorVisible);
    }

    public Validator<String> getDefaultValidator() {
        return (Validator & Serializable)(value, context) -> this.getValidationSupport().checkValidity((String)value);
    }

    public Registration addValidationStatusChangeListener(ValidationStatusChangeListener<String> listener) {
        return this.addClientValidatedEventListener((ComponentEventListener & Serializable)event -> listener.validationStatusChanged(new ValidationStatusChangeEvent((HasValue)this, !this.isInvalid())));
    }

    public void setManualValidation(boolean enabled) {
        this.manualValidationEnabled = enabled;
    }

    protected void validate() {
        if (!this.manualValidationEnabled) {
            this.setInvalid(this.getValidationSupport().isInvalid(this.getValue()));
        }
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        ClientValidationUtil.preventWebComponentFromModifyingInvalidState((Component)this);
    }
}

