/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery;

import de.agilecoders.wicket.jquery.util.CharSequenceWrapper;
import de.agilecoders.wicket.jquery.util.Strings2;
import org.apache.wicket.Component;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public abstract class Attr
implements CharSequence {
    private static final Attr NULL_VALUE = new NullValue();
    private CharSequence selector;

    public static boolean isNullOrEmpty(Attr attr) {
        return Strings.isEmpty((CharSequence)attr) || attr instanceof NullValue;
    }

    protected Attr(CharSequence selector) {
        this.selector = Args.notEmpty((CharSequence)selector, (String)"selector");
    }

    @Override
    public int length() {
        return this.selector.length();
    }

    @Override
    public char charAt(int index) {
        return this.selector.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.selector.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.selector.toString();
    }

    public int hashCode() {
        return this.selector.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CharSequence && this.selector.equals(obj);
    }

    public static Attr nullValue() {
        return NULL_VALUE;
    }

    public static class Auto
    extends Attr {
        protected Auto(Object value) {
            super(new CharSequenceWrapper(value));
        }
    }

    public static class Quoted
    extends Attr {
        protected Quoted(CharSequence selector) {
            super("'" + JavaScriptUtils.escapeQuotes((CharSequence)selector) + "'");
        }
    }

    public static class Plain
    extends Attr {
        protected Plain(CharSequence selector) {
            super(selector);
        }
    }

    public static class MarkupId
    extends Attr {
        protected MarkupId(Component component) {
            this(Strings2.getMarkupId((Component)Args.notNull((Object)component, (String)"component")), false);
        }

        protected MarkupId(CharSequence markupId) {
            this(Strings2.escapeMarkupId(Args.notEmpty((CharSequence)markupId, (String)"markupId")), false);
        }

        private MarkupId(CharSequence markupId, boolean quote) {
            super(quote ? "'#" + markupId + "'" : "#" + markupId);
        }

        public MarkupId quoted() {
            if (this.toString().charAt(0) == '#') {
                return new MarkupId(this.toString().substring(1), true);
            }
            return this;
        }
    }

    public static class NullValue
    extends Plain {
        protected NullValue() {
            super("null");
        }
    }
}

