/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class LinkedTreeSet<E>
extends AbstractSet<E> {
    private final Set<E> elements = new TreeSet<Object>(ValueComparator.ascWithoutListHandling());
    private final List<E> orderedElements = new ArrayList();

    public LinkedTreeSet() {
    }

    public LinkedTreeSet(Collection<? extends E> other) {
        this.addAll(other);
    }

    @Override
    public boolean add(E e) {
        if (this.elements.add(e)) {
            this.orderedElements.add(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (!this.elements.remove(o)) {
            return false;
        }
        this.removeFromOrderedElements(o);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(new LinkedTreeSet(c));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(new LinkedTreeSet(c));
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.orderedElements.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    private void removeFromOrderedElements(Object o) {
        this.orderedElements.removeIf(value -> Utils.nullAwareEquals(value, o));
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private final Iterator<E> delegate;
            private E currentElement;
            {
                this.delegate = LinkedTreeSet.this.orderedElements.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public E next() {
                this.currentElement = this.delegate.next();
                return this.currentElement;
            }

            @Override
            public void remove() {
                this.delegate.remove();
                LinkedTreeSet.this.remove(this.currentElement);
            }
        };
    }

    @Override
    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof LinkedTreeSet)) {
            return false;
        }
        LinkedTreeSet otherSet = (LinkedTreeSet)o;
        return this.orderedElements.equals(otherSet.orderedElements);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public String toString() {
        return this.orderedElements.toString();
    }
}

