/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.aggregation.stage.AbstractLookupStage;
import de.bwaldvogel.mongo.bson.Document;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class LookupStage
extends AbstractLookupStage {
    private static final String LOCAL_FIELD = "localField";
    private static final String FOREIGN_FIELD = "foreignField";
    private static final Set<String> CONFIGURATION_KEYS = new HashSet<String>();
    private final String localField;
    private final String foreignField;
    private final String as;
    private final MongoCollection<?> collection;

    public LookupStage(Document configuration, MongoDatabase mongoDatabase) {
        String from = this.readStringConfigurationProperty(configuration, "from");
        this.collection = mongoDatabase.resolveCollection(from, false);
        this.localField = this.readStringConfigurationProperty(configuration, LOCAL_FIELD);
        this.foreignField = this.readStringConfigurationProperty(configuration, FOREIGN_FIELD);
        this.as = this.readStringConfigurationProperty(configuration, "as");
        this.ensureAllConfigurationPropertiesAreKnown(configuration, CONFIGURATION_KEYS);
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        return stream.map(this::resolveRemoteField);
    }

    private Document resolveRemoteField(Document document) {
        Object value = document.get(this.localField);
        List<Document> documents = this.lookupValue(value);
        Document result = document.clone();
        result.put(this.as, (Object)documents);
        return result;
    }

    private List<Document> lookupValue(Object value) {
        if (value instanceof List) {
            return ((List)value).stream().flatMap(item -> this.lookupValue(item).stream()).collect(Collectors.toList());
        }
        Document query = new Document(this.foreignField, value);
        return this.collection.handleQueryAsStream(query).collect(Collectors.toList());
    }

    static {
        CONFIGURATION_KEYS.add("from");
        CONFIGURATION_KEYS.add(LOCAL_FIELD);
        CONFIGURATION_KEYS.add(FOREIGN_FIELD);
        CONFIGURATION_KEYS.add("as");
    }
}

