/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Index;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.exception.DuplicateKeyError;
import de.bwaldvogel.mongo.exception.KeyConstraintError;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.BSONObject;

public abstract class AbstractUniqueIndex<KEY>
extends Index<KEY> {
    protected AbstractUniqueIndex(String key, boolean ascending) {
        super(key, ascending);
    }

    protected abstract KEY removeDocument(Object var1);

    protected abstract boolean containsKeyValue(Object var1);

    protected abstract void putKeyValue(Object var1, KEY var2);

    protected abstract Iterable<Map.Entry<Object, KEY>> getIterable();

    protected abstract KEY getKey(Object var1);

    @Override
    public synchronized KEY remove(BSONObject document) {
        Object value = this.getKeyValue(document);
        return this.removeDocument(value);
    }

    @Override
    public synchronized void checkAdd(BSONObject document) throws MongoServerError {
        if (!Utils.hasSubdocumentValue(document, this.key)) {
            return;
        }
        Object keyValue = this.getKeyValue(document);
        if (this.containsKeyValue(keyValue)) {
            throw new DuplicateKeyError(this, keyValue);
        }
    }

    @Override
    public synchronized void add(BSONObject document, KEY key) throws MongoServerError {
        this.checkAdd(document);
        if (!Utils.hasSubdocumentValue(document, this.key)) {
            return;
        }
        Object keyValue = this.getKeyValue(document);
        this.putKeyValue(keyValue, key);
    }

    @Override
    public void checkUpdate(BSONObject oldDocument, BSONObject newDocument) throws MongoServerError {
        if (this.nullAwareEqualsKeys(oldDocument, newDocument)) {
            return;
        }
        this.checkAdd(newDocument);
    }

    @Override
    public void updateInPlace(BSONObject oldDocument, BSONObject newDocument) throws KeyConstraintError {
        if (this.nullAwareEqualsKeys(oldDocument, newDocument)) {
            return;
        }
    }

    @Override
    public synchronized boolean canHandle(BSONObject query) {
        if (!query.keySet().equals(Collections.singleton(this.key))) {
            return false;
        }
        Object queryValue = query.get(this.key);
        if (queryValue instanceof BSONObject) {
            for (String key : ((BSONObject)queryValue).keySet()) {
                if (key.equals("$in") || !key.startsWith("$")) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized Iterable<KEY> getKeys(BSONObject query) {
        KEY key;
        Object keyValue = Utils.normalizeValue(query.get(this.key));
        if (keyValue instanceof BSONObject) {
            BSONObject keyObj = (BSONObject)keyValue;
            if (Utils.containsQueryExpression(keyObj)) {
                if (keyObj.keySet().size() != 1) {
                    throw new UnsupportedOperationException("illegal query key: " + keyValue);
                }
                String expression = (String)keyObj.keySet().iterator().next();
                if (expression.startsWith("$")) {
                    return this.getPositionsForExpression(keyObj, expression);
                }
            }
        } else if (keyValue instanceof Pattern) {
            ArrayList<KEY> positions = new ArrayList<KEY>();
            for (Map.Entry<Object, KEY> entry : this.getIterable()) {
                Object obj = entry.getKey();
                Matcher matcher = ((Pattern)keyValue).matcher(obj.toString());
                if (!matcher.find()) continue;
                positions.add(entry.getValue());
            }
            return positions;
        }
        if ((key = this.getKey(keyValue)) == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(key);
    }

    private boolean nullAwareEqualsKeys(BSONObject oldDocument, BSONObject newDocument) {
        Object oldKey = this.getKeyValue(oldDocument);
        Object newKey = this.getKeyValue(newDocument);
        return Utils.nullAwareEquals(oldKey, newKey);
    }

    private Iterable<KEY> getPositionsForExpression(BSONObject keyObj, String operator) {
        if (operator.equals("$in")) {
            TreeSet queriedObjects = new TreeSet((Collection)keyObj.get(operator));
            ArrayList<KEY> allKeys = new ArrayList<KEY>();
            for (Object object : queriedObjects) {
                Object keyValue = Utils.normalizeValue(object);
                KEY key = this.getKey(keyValue);
                if (key == null) continue;
                allKeys.add(key);
            }
            return allKeys;
        }
        throw new UnsupportedOperationException("unsupported query expression: " + operator);
    }
}

