/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.exception.KeyConstraintError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import org.bson.BSONObject;

public abstract class Index<KEY> {
    protected final String key;
    protected final boolean ascending;

    protected Index(String key, boolean ascending) {
        this.key = key;
        this.ascending = ascending;
    }

    public String getName() {
        if (this.key.equals("_id")) {
            return "_id_";
        }
        return this.key + "_" + (this.ascending ? "1" : "-1");
    }

    protected Object getKeyValue(BSONObject document) {
        Object value = Utils.getSubdocumentValue(document, this.key);
        return Utils.normalizeValue(value);
    }

    public abstract void checkAdd(BSONObject var1) throws MongoServerException;

    public abstract void add(BSONObject var1, KEY var2) throws MongoServerException;

    public abstract KEY remove(BSONObject var1);

    public abstract boolean canHandle(BSONObject var1);

    public abstract Iterable<KEY> getKeys(BSONObject var1);

    public abstract long getCount();

    public abstract long getDataSize();

    public abstract void checkUpdate(BSONObject var1, BSONObject var2) throws MongoServerException;

    public abstract void updateInPlace(BSONObject var1, BSONObject var2) throws KeyConstraintError;
}

