/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.CircularReferenceDetector;
import de.danielbechler.diff.CircularReferenceDetectorFactory;
import de.danielbechler.diff.Configuration;
import de.danielbechler.diff.Differ;
import de.danielbechler.diff.DifferFactory;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.node.DefaultNode;
import de.danielbechler.diff.node.Node;
import de.danielbechler.diff.path.PropertyPath;
import de.danielbechler.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DifferDelegator {
    private final DifferFactory differFactory;
    private final CircularReferenceDetectorFactory circularReferenceDetectorFactory;
    private final Configuration configuration;
    private CircularReferenceDetector workingCircularReferenceDetector;
    private CircularReferenceDetector baseCircularReferenceDetector;

    public DifferDelegator(DifferFactory differFactory, CircularReferenceDetectorFactory circularReferenceDetectorFactory, Configuration configuration) {
        Assert.notNull(differFactory, "differFactory");
        Assert.notNull(circularReferenceDetectorFactory, "circularReferenceDetectorFactory");
        Assert.notNull(configuration, "configuration");
        this.differFactory = differFactory;
        this.circularReferenceDetectorFactory = circularReferenceDetectorFactory;
        this.configuration = configuration;
        this.resetInstanceMemory();
    }

    public Node delegate(Node parentNode, Instances instances) {
        Assert.notNull(instances, "instances");
        Class<?> type = instances.getType();
        if (type == null) {
            return DifferDelegator.newDefaultNode(parentNode, instances, type);
        }
        return this.delegateWithCircularReferenceTracking(parentNode, instances);
    }

    private Node delegateWithCircularReferenceTracking(Node parentNode, Instances instances) {
        Node node;
        try {
            this.rememberInstances(parentNode, instances);
            try {
                node = this.compare(parentNode, instances);
            }
            finally {
                this.forgetInstances(instances);
            }
        }
        catch (CircularReferenceDetector.CircularReferenceException e) {
            node = this.newCircularNode(parentNode, instances, e.getPropertyPath());
            this.configuration.getExceptionListener().onCircularReferenceException(node);
        }
        if (parentNode == null) {
            this.resetInstanceMemory();
        }
        return node;
    }

    private Node findNodeMatchingPropertyPath(Node node, PropertyPath propertyPath) {
        if (node == null) {
            return null;
        }
        if (node.matches(propertyPath)) {
            return node;
        }
        return this.findNodeMatchingPropertyPath(node.getParentNode(), propertyPath);
    }

    private static Node newDefaultNode(Node parentNode, Instances instances, Class<?> type) {
        return new DefaultNode(parentNode, instances.getSourceAccessor(), type);
    }

    private Node newCircularNode(Node parentNode, Instances instances, PropertyPath circleStartPath) {
        DefaultNode node = new DefaultNode(parentNode, instances.getSourceAccessor(), instances.getType());
        node.setState(Node.State.CIRCULAR);
        node.setCircleStartPath(circleStartPath);
        node.setCircleStartNode(this.findNodeMatchingPropertyPath(parentNode, circleStartPath));
        return node;
    }

    private Node compare(Node parentNode, Instances instances) {
        Differ<?> differ = this.differFactory.createDiffer(instances.getType(), this);
        if (differ != null) {
            return differ.compare(parentNode, instances);
        }
        throw new IllegalStateException("Couldn't create Differ for type '" + instances.getType() + "'. This mustn't happen, as there should always be a fallback differ.");
    }

    protected final void resetInstanceMemory() {
        this.workingCircularReferenceDetector = this.circularReferenceDetectorFactory.create();
        this.baseCircularReferenceDetector = this.circularReferenceDetectorFactory.create();
    }

    protected void forgetInstances(Instances instances) {
        this.workingCircularReferenceDetector.remove(instances.getWorking());
        this.baseCircularReferenceDetector.remove(instances.getBase());
    }

    protected void rememberInstances(Node parentNode, Instances instances) {
        PropertyPath propertyPath = instances.getPropertyPath(parentNode);
        this.workingCircularReferenceDetector.push(instances.getWorking(), propertyPath);
        this.baseCircularReferenceDetector.push(instances.getBase(), propertyPath);
    }
}

