/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.util;

import de.danielbechler.util.Classes;
import de.danielbechler.util.Collections;
import de.danielbechler.util.Strings;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assert {
    private Assert() {
    }

    public static void equalTypesOrNull(Object ... objects) {
        Set<Class<?>> types = Classes.typesOf(objects);
        Class previousType = null;
        for (Class clazz : types) {
            if (previousType != null && !clazz.equals(previousType)) {
                throw new IllegalArgumentException("The given objects should be either null or of the same type ('" + previousType + "') = " + types);
            }
            previousType = clazz;
        }
    }

    public static void notNull(Object object, String name) {
        Assert.notEmpty(name, "name");
        if (object == null) {
            throw new IllegalArgumentException("'" + name + "' must not be null");
        }
    }

    public static void notEmpty(Collection<?> collection, String name) {
        Assert.notEmpty(name, "name");
        if (Collections.isEmpty(collection)) {
            throw new IllegalArgumentException("'" + name + "' must not be null or empty");
        }
    }

    public static void notEmpty(String text, String name) throws IllegalArgumentException {
        Assert.hasText(text, name);
    }

    public static void hasText(String value, String name) throws IllegalArgumentException {
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("'name' must not be null or empty");
        }
        if (Strings.isEmpty(value)) {
            throw new IllegalArgumentException("'" + name + "' must not be null or empty");
        }
    }
}

