/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.DifferDelegator;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.NodeInspector;
import de.danielbechler.diff.PropertyNodeFactory;
import de.danielbechler.diff.TestOnly;
import de.danielbechler.diff.accessor.Accessor;
import de.danielbechler.diff.accessor.exception.ExceptionListener;
import de.danielbechler.diff.accessor.exception.PropertyReadException;
import de.danielbechler.diff.accessor.exception.PropertyWriteException;
import de.danielbechler.diff.node.Node;
import de.danielbechler.util.Assert;

class BeanPropertyComparisonDelegator {
    private final DifferDelegator delegator;
    private final NodeInspector nodeInspector;
    private PropertyNodeFactory propertyNodeFactory = new PropertyNodeFactory();
    private final ExceptionListener exceptionListener;

    public BeanPropertyComparisonDelegator(DifferDelegator delegator, NodeInspector nodeInspector, ExceptionListener exceptionListener) {
        Assert.notNull(delegator, "delegator");
        Assert.notNull(nodeInspector, "nodeInspector");
        Assert.notNull(exceptionListener, "exceptionListener");
        this.delegator = delegator;
        this.nodeInspector = nodeInspector;
        this.exceptionListener = exceptionListener;
    }

    public Node compare(Node beanNode, Instances beanInstances, Accessor propertyAccessor) {
        Assert.notNull(beanNode, "beanNode");
        Assert.notNull(beanInstances, "beanInstances");
        Assert.notNull(propertyAccessor, "propertyAccessor");
        Node propertyNode = this.propertyNodeFactory.createPropertyNode(beanNode, propertyAccessor);
        if (this.nodeInspector.isIgnored(propertyNode)) {
            propertyNode.setState(Node.State.IGNORED);
            return propertyNode;
        }
        try {
            return this.delegator.delegate(beanNode, beanInstances.access(propertyAccessor));
        }
        catch (PropertyReadException e) {
            return this.exceptionListener.onPropertyReadException(e, propertyNode);
        }
        catch (PropertyWriteException e) {
            return this.exceptionListener.onPropertyWriteException(e, propertyNode);
        }
    }

    @TestOnly
    public void setPropertyNodeFactory(PropertyNodeFactory propertyNodeFactory) {
        this.propertyNodeFactory = propertyNodeFactory;
    }
}

