/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.accessor;

import de.danielbechler.diff.accessor.AbstractAccessor;
import de.danielbechler.diff.accessor.TypeAwareAccessor;
import de.danielbechler.diff.accessor.exception.PropertyReadException;
import de.danielbechler.diff.accessor.exception.PropertyWriteException;
import de.danielbechler.diff.path.Element;
import de.danielbechler.diff.path.NamedPropertyElement;
import de.danielbechler.util.Assert;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAccessor
extends AbstractAccessor
implements TypeAwareAccessor {
    private static final Logger logger = LoggerFactory.getLogger(PropertyAccessor.class);
    private final String propertyName;
    private final Class<?> type;
    private final Method readMethod;
    private final Method writeMethod;

    public PropertyAccessor(String propertyName, Method readMethod, Method writeMethod) {
        Assert.notNull(propertyName, "propertyName");
        Assert.notNull(readMethod, "readMethod");
        this.propertyName = propertyName;
        this.readMethod = PropertyAccessor.makeAccessible(readMethod);
        this.writeMethod = PropertyAccessor.makeAccessible(writeMethod);
        this.type = this.readMethod.getReturnType();
    }

    private static Method makeAccessible(Method method) {
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    @Override
    public void set(Object target, Object value) {
        if (target == null) {
            logger.debug("The target object is null");
            this.logFailedSet(value);
        } else if (this.writeMethod == null) {
            logger.debug("No setter found for property '{}'", (Object)this.propertyName);
            this.tryToReplaceContentOfCollectionTypes(target, value);
        } else {
            this.invokeWriteMethod(target, value);
        }
    }

    private void logFailedSet(Object value) {
        logger.info("Couldn't set new value '{}' for property '{}'", value, (Object)this.propertyName);
    }

    private void invokeWriteMethod(Object target, Object value) {
        try {
            this.writeMethod.invoke(target, value);
        }
        catch (Exception e) {
            PropertyWriteException ex = new PropertyWriteException(e, value);
            ex.setPropertyName(this.propertyName);
            ex.setTargetType(this.getType());
            throw ex;
        }
    }

    private void tryToReplaceContentOfCollectionTypes(Object target, Object value) {
        if (Collection.class.isAssignableFrom(this.readMethod.getReturnType())) {
            PropertyAccessor.tryToReplaceCollectionContent((Collection)this.get(target), (Collection)value);
            return;
        }
        if (Map.class.isAssignableFrom(this.readMethod.getReturnType())) {
            PropertyAccessor.tryToReplaceMapContent((Map)this.get(target), (Map)value);
            return;
        }
        this.logFailedSet(value);
    }

    private static boolean tryToReplaceCollectionContent(Collection<Object> target, Collection<Object> value) {
        if (target == null) {
            return false;
        }
        try {
            target.clear();
            target.addAll(value);
            return true;
        }
        catch (Exception unmodifiable) {
            logger.debug("Failed to replace content of existing Collection", (Throwable)unmodifiable);
            return false;
        }
    }

    private static boolean tryToReplaceMapContent(Map<Object, Object> target, Map<Object, Object> value) {
        if (target == null) {
            return false;
        }
        try {
            target.clear();
            target.putAll(value);
            return true;
        }
        catch (Exception unmodifiable) {
            logger.debug("Failed to replace content of existing Map", (Throwable)unmodifiable);
            return false;
        }
    }

    @Override
    public Object get(Object target) {
        if (target == null) {
            return null;
        }
        try {
            return this.readMethod.invoke(target, new Object[0]);
        }
        catch (Exception e) {
            PropertyReadException ex = new PropertyReadException(e);
            ex.setPropertyName(this.propertyName);
            ex.setTargetType(target.getClass());
            throw ex;
        }
    }

    @Override
    public void unset(Object target) {
        this.set(target, null);
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Element getPathElement() {
        return new NamedPropertyElement(this.propertyName);
    }

    public Set<Annotation> getReadMethodAnnotations() {
        return new LinkedHashSet<Annotation>(Arrays.asList(this.readMethod.getAnnotations()));
    }

    public <T extends Annotation> T getReadMethodAnnotation(Class<T> annotationClass) {
        Set<Annotation> annotations = this.getReadMethodAnnotations();
        assert (annotations != null) : "Something is wrong here. The contract of getReadAnnotations() guarantees a non-null return value.";
        for (Annotation annotation : annotations) {
            if (!annotationClass.isAssignableFrom(annotation.annotationType())) continue;
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        return null;
    }

    public String toString() {
        return "property '" + this.propertyName + "'";
    }
}

