/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.accessor.exception;

import de.danielbechler.diff.accessor.exception.ExceptionListener;
import de.danielbechler.diff.accessor.exception.PropertyReadException;
import de.danielbechler.diff.accessor.exception.PropertyWriteException;
import de.danielbechler.diff.node.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionListener
implements ExceptionListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionListener.class);

    public void onCircularReferenceException(Node node) {
        logger.warn("Detected circular reference in node at path {}. Going deeper would cause an infinite loop, so I'll stop looking at this instance along the current path.", (Object)node.getPropertyPath());
    }

    public Node onPropertyWriteException(PropertyWriteException ex, Node propertyNode) {
        logger.info("Couldn't set new value '{}' for property '{}'", ex.getNewValue(), (Object)ex.getPropertyName());
        throw ex;
    }

    public Node onPropertyReadException(PropertyReadException ex, Node propertyNode) {
        throw ex;
    }
}

