/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.example;

import de.danielbechler.diff.ObjectDifferFactory;
import de.danielbechler.diff.node.Node;
import de.danielbechler.diff.visitor.NodeHierarchyVisitor;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

class CanonicalAccessorExample {
    private CanonicalAccessorExample() {
    }

    public static void main(String[] args) {
        AddressBook workingAddressBook = new AddressBook();
        Contact workingContact = new Contact("Walter White", "Heisenberg");
        workingAddressBook.setContacts(Arrays.asList(workingContact));
        AddressBook baseAddressBook = new AddressBook();
        Contact baseContact = new Contact("Walter White");
        baseAddressBook.setContacts(Arrays.asList(baseContact));
        Node rootNode = ObjectDifferFactory.getInstance().compare(workingAddressBook, baseAddressBook);
        Node contactsNode = CanonicalAccessorExample.getFirstChildOf(rootNode);
        Node contactNode = CanonicalAccessorExample.getFirstChildOf(contactsNode);
        Node nicknameNode = CanonicalAccessorExample.getFirstChildOf(contactNode);
        rootNode.visit(new NodeHierarchyVisitor());
        AddressBook addressBook = (AddressBook)rootNode.get(workingAddressBook);
        List contacts = (List)contactsNode.get(addressBook);
        Contact contact = (Contact)contactNode.get(contacts);
        assert (rootNode.get(workingAddressBook) == rootNode.canonicalGet(workingAddressBook));
        assert (contactsNode.get(addressBook) == contactsNode.canonicalGet(workingAddressBook));
        assert (contactNode.get(contacts) == contactNode.canonicalGet(workingAddressBook));
        assert (nicknameNode.get(contact) == nicknameNode.canonicalGet(workingAddressBook));
    }

    private static Node getFirstChildOf(Node rootNode) {
        return rootNode.getChildren().iterator().next();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddressBook {
        private List<Contact> contacts = new LinkedList<Contact>();

        public List<Contact> getContacts() {
            return this.contacts;
        }

        public void setContacts(List<Contact> contacts) {
            this.contacts = contacts;
        }
    }

    public static class Contact {
        private final String name;
        private String nickname;

        public Contact(String name) {
            this.name = name;
        }

        public Contact(String name, String nickname) {
            this.name = name;
            this.nickname = nickname;
        }

        public String getName() {
            return this.name;
        }

        public String getNickname() {
            return this.nickname;
        }

        public void setNickname(String nickname) {
            this.nickname = nickname;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Contact)) {
                return false;
            }
            Contact contact = (Contact)o;
            return !(this.name != null ? !this.name.equals(contact.name) : contact.name != null);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Contact");
            sb.append("{name='").append(this.name).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

