/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.introspect;

import de.danielbechler.diff.accessor.Accessor;
import de.danielbechler.diff.accessor.PropertyAccessor;
import de.danielbechler.diff.annotation.ObjectDiffEqualsOnlyType;
import de.danielbechler.diff.annotation.ObjectDiffProperty;
import de.danielbechler.diff.introspect.Introspector;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Collections;
import de.danielbechler.util.Exceptions;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardIntrospector
implements Introspector {
    @Override
    public Iterable<Accessor> introspect(Class<?> type) {
        Assert.notNull(type, "type");
        try {
            return this.internalIntrospect(type);
        }
        catch (IntrospectionException e) {
            throw Exceptions.escalate(e);
        }
    }

    private Iterable<Accessor> internalIntrospect(Class<?> type) throws IntrospectionException {
        PropertyDescriptor[] descriptors = this.getBeanInfo(type).getPropertyDescriptors();
        ArrayList<Accessor> accessors = new ArrayList<Accessor>(descriptors.length);
        PropertyDescriptor[] propertyDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor descriptor = propertyDescriptorArray[n2];
            PropertyAccessor accessor = StandardIntrospector.handlePropertyDescriptor(descriptor);
            if (accessor != null) {
                accessors.add(accessor);
            }
            ++n2;
        }
        return accessors;
    }

    protected BeanInfo getBeanInfo(Class<?> type) throws IntrospectionException {
        return java.beans.Introspector.getBeanInfo(type);
    }

    private static PropertyAccessor handlePropertyDescriptor(PropertyDescriptor descriptor) {
        if (StandardIntrospector.shouldSkip(descriptor)) {
            return null;
        }
        String propertyName = descriptor.getName();
        Method readMethod = descriptor.getReadMethod();
        Method writeMethod = descriptor.getWriteMethod();
        PropertyAccessor accessor = new PropertyAccessor(propertyName, readMethod, writeMethod);
        StandardIntrospector.handleObjectDiffPropertyAnnotation(readMethod, accessor);
        StandardIntrospector.handleEqualsOnlyTypeAnnotation(readMethod, accessor);
        return accessor;
    }

    private static boolean shouldSkip(PropertyDescriptor descriptor) {
        return descriptor.getName().equals("class") || descriptor.getReadMethod() == null;
    }

    private static void handleObjectDiffPropertyAnnotation(Method readMethod, PropertyAccessor propertyAccessor) {
        ObjectDiffProperty annotation = readMethod.getAnnotation(ObjectDiffProperty.class);
        if (annotation != null) {
            propertyAccessor.setEqualsOnly(annotation.equalsOnly());
            propertyAccessor.setIgnored(annotation.ignore());
            propertyAccessor.setCategories(Collections.setOf(annotation.categories()));
            propertyAccessor.setEqualsOnlyValueProviderMethod(annotation.equalsOnlyValueProviderMethod());
        }
    }

    private static void handleEqualsOnlyTypeAnnotation(Method readMethod, PropertyAccessor propertyAccessor) {
        ObjectDiffEqualsOnlyType annotation = readMethod.getReturnType().getAnnotation(ObjectDiffEqualsOnlyType.class);
        if (annotation != null) {
            propertyAccessor.setEqualsOnly(true);
            propertyAccessor.setEqualsOnlyValueProviderMethod(annotation.valueProviderMethod());
        }
    }
}

