/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.path;

import de.danielbechler.diff.path.CollectionElement;
import de.danielbechler.diff.path.Element;
import de.danielbechler.diff.path.MapElement;
import de.danielbechler.diff.path.NamedPropertyElement;
import de.danielbechler.diff.path.RootElement;
import de.danielbechler.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyPath {
    private final List<Element> elements;

    private PropertyPath(List<Element> elements) {
        this.elements = Collections.unmodifiableList(elements);
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public boolean matches(PropertyPath propertyPath) {
        return propertyPath.equals(this);
    }

    public boolean isParentOf(PropertyPath propertyPath) {
        Iterator<Element> iterator1 = this.elements.iterator();
        Iterator<Element> iterator2 = propertyPath.getElements().iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Element next2;
            Element next1 = iterator1.next();
            if (next1.equals(next2 = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Element> iterator = this.elements.iterator();
        Element previousElement = null;
        while (iterator.hasNext()) {
            Element element = iterator.next();
            if (element instanceof RootElement) {
                sb.append("/");
            } else if (element instanceof CollectionElement || element instanceof MapElement) {
                sb.append(element);
            } else if (previousElement instanceof RootElement) {
                sb.append(element);
            } else {
                sb.append('/');
                sb.append(element);
            }
            previousElement = element;
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyPath that = (PropertyPath)o;
        return this.elements.equals(that.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public static InitialBuilder createBuilder() {
        return new InitialBuilderImpl();
    }

    public static PropertyPath buildWith(String propertyName, String ... additionalPropertyNames) {
        return PropertyPath.createBuilder().withRoot().withPropertyName(propertyName, additionalPropertyNames).build();
    }

    public static PropertyPath buildRootPath() {
        return PropertyPath.createBuilder().withRoot().build();
    }

    /* synthetic */ PropertyPath(List list, PropertyPath propertyPath) {
        this(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AppendableBuilder {
        public AppendableBuilder withElement(Element var1);

        public AppendableBuilder withPropertyName(String var1, String ... var2);

        public <T> AppendableBuilder withCollectionItem(T var1);

        public <K> AppendableBuilder withMapKey(K var1);

        public PropertyPath build();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AppendableBuilderImpl
    implements AppendableBuilder {
        private final List<Element> elements;

        public AppendableBuilderImpl(List<Element> elements) {
            Assert.notEmpty(elements, "elements");
            this.elements = new ArrayList<Element>(elements);
        }

        @Override
        public AppendableBuilder withElement(Element element) {
            Assert.notNull(element, "element");
            this.elements.add(element);
            return this;
        }

        @Override
        public AppendableBuilder withPropertyName(String name, String ... names) {
            this.elements.add(new NamedPropertyElement(name));
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.elements.add(new NamedPropertyElement(s));
                ++n2;
            }
            return this;
        }

        @Override
        public <T> AppendableBuilder withCollectionItem(T item) {
            this.elements.add(new CollectionElement(item));
            return this;
        }

        @Override
        public <K> AppendableBuilder withMapKey(K key) {
            Assert.notNull(key, "key");
            this.elements.add(new MapElement(key));
            return this;
        }

        @Override
        public PropertyPath build() {
            if (this.elements.isEmpty()) {
                throw new IllegalStateException("A property path cannot be empty");
            }
            if (!(this.elements.get(0) instanceof RootElement)) {
                throw new IllegalStateException("A property path must start with a root element");
            }
            if (this.elementCount(RootElement.class) > 1) {
                throw new IllegalStateException("A property path cannot contain multiple root elements");
            }
            return new PropertyPath(this.elements, null);
        }

        private int elementCount(Class<? extends Element> type) {
            assert (type != null) : "Type must not be null";
            int count = 0;
            for (Element element : this.elements) {
                if (!type.isAssignableFrom(element.getClass())) continue;
                ++count;
            }
            return count;
        }
    }

    public static interface InitialBuilder {
        public AppendableBuilder withPropertyPath(PropertyPath var1);

        public AppendableBuilder withRoot();
    }

    private static final class InitialBuilderImpl
    implements InitialBuilder {
        private InitialBuilderImpl() {
        }

        public AppendableBuilder withRoot() {
            ArrayList<Element> elements = new ArrayList<Element>(1);
            elements.add(RootElement.getInstance());
            return new AppendableBuilderImpl(elements);
        }

        public AppendableBuilder withPropertyPath(PropertyPath propertyPath) {
            Assert.notNull(propertyPath, "propertyPath");
            return new AppendableBuilderImpl(new ArrayList<Element>(propertyPath.getElements()));
        }
    }
}

