/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.comparison;

import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.comparison.ComparableComparisonStrategy;
import de.danielbechler.diff.comparison.ComparisonConfigurer;
import de.danielbechler.diff.comparison.ComparisonStrategy;
import de.danielbechler.diff.comparison.ComparisonStrategyResolver;
import de.danielbechler.diff.comparison.EqualsOnlyComparisonStrategy;
import de.danielbechler.diff.comparison.ObjectDiffPropertyComparisonStrategyResolver;
import de.danielbechler.diff.comparison.PrimitiveDefaultValueMode;
import de.danielbechler.diff.comparison.PrimitiveDefaultValueModeResolver;
import de.danielbechler.diff.introspection.ObjectDiffEqualsOnlyType;
import de.danielbechler.diff.introspection.ObjectDiffProperty;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.path.NodePath;
import de.danielbechler.diff.path.NodePathValueHolder;
import de.danielbechler.util.Classes;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonService
implements ComparisonConfigurer,
ComparisonStrategyResolver,
PrimitiveDefaultValueModeResolver {
    private final NodePathValueHolder<ComparisonStrategy> nodePathComparisonStrategies = NodePathValueHolder.of(ComparisonStrategy.class);
    private final Map<Class<?>, ComparisonStrategy> typeComparisonStrategyMap = new HashMap();
    private final ObjectDifferBuilder objectDifferBuilder;
    private PrimitiveDefaultValueMode primitiveDefaultValueMode = PrimitiveDefaultValueMode.UNASSIGNED;

    public ComparisonService(ObjectDifferBuilder objectDifferBuilder) {
        this.objectDifferBuilder = objectDifferBuilder;
    }

    @Override
    public ComparisonStrategy resolveComparisonStrategy(DiffNode node) {
        ObjectDiffEqualsOnlyType objectDiffEqualsOnlyType;
        ComparisonStrategy comparisonStrategyFromObjectDiffEqualsOnlyTypeAnnotation;
        ComparisonStrategy comparisonStrategy = this.nodePathComparisonStrategies.valueForNodePath(node.getPath());
        if (comparisonStrategy != null) {
            return comparisonStrategy;
        }
        Class<?> valueType = node.getValueType();
        if (this.typeComparisonStrategyMap.containsKey(valueType)) {
            return this.typeComparisonStrategyMap.get(valueType);
        }
        if (Classes.isComparableType(valueType)) {
            return new ComparableComparisonStrategy();
        }
        if (Classes.isSimpleType(valueType)) {
            return new EqualsOnlyComparisonStrategy();
        }
        ObjectDiffPropertyComparisonStrategyResolver comparisonStrategyResolver = ObjectDiffPropertyComparisonStrategyResolver.instance;
        ObjectDiffProperty objectDiffProperty = node.getPropertyAnnotation(ObjectDiffProperty.class);
        ComparisonStrategy comparisonStrategyFromObjectDiffPropertyAnnotation = comparisonStrategyResolver.comparisonStrategyForAnnotation(objectDiffProperty);
        if (comparisonStrategyFromObjectDiffPropertyAnnotation != null) {
            return comparisonStrategyFromObjectDiffPropertyAnnotation;
        }
        if (valueType != null && (comparisonStrategyFromObjectDiffEqualsOnlyTypeAnnotation = comparisonStrategyResolver.comparisonStrategyForAnnotation(objectDiffEqualsOnlyType = valueType.getAnnotation(ObjectDiffEqualsOnlyType.class))) != null) {
            return comparisonStrategyFromObjectDiffEqualsOnlyTypeAnnotation;
        }
        return null;
    }

    @Override
    public PrimitiveDefaultValueMode resolvePrimitiveDefaultValueMode(DiffNode node) {
        return this.primitiveDefaultValueMode;
    }

    @Override
    public ComparisonConfigurer.Of ofNode(NodePath nodePath) {
        return new OfNodePath(nodePath);
    }

    @Override
    public ComparisonConfigurer.Of ofType(Class<?> type) {
        return new OfType(type);
    }

    @Override
    public ComparisonConfigurer.OfPrimitiveTypes ofPrimitiveTypes() {
        return new OfPrimitiveTypesImpl();
    }

    @Override
    public ObjectDifferBuilder and() {
        return this.objectDifferBuilder;
    }

    private static abstract class AbstractOf
    implements ComparisonConfigurer.Of {
        private AbstractOf() {
        }

        public ComparisonConfigurer toUseEqualsMethod() {
            return this.toUse(new EqualsOnlyComparisonStrategy());
        }

        public ComparisonConfigurer toUseEqualsMethodOfValueProvidedByMethod(String propertyName) {
            return this.toUse(new EqualsOnlyComparisonStrategy(propertyName));
        }

        public ComparisonConfigurer toUseCompareToMethod() {
            return this.toUse(new ComparableComparisonStrategy());
        }
    }

    private class OfNodePath
    extends AbstractOf {
        private final NodePath nodePath;

        public OfNodePath(NodePath nodePath) {
            this.nodePath = nodePath;
        }

        public ComparisonConfigurer toUse(ComparisonStrategy comparisonStrategy) {
            ComparisonService.this.nodePathComparisonStrategies.put(this.nodePath, comparisonStrategy);
            return ComparisonService.this;
        }
    }

    private class OfPrimitiveTypesImpl
    implements ComparisonConfigurer.OfPrimitiveTypes {
        private OfPrimitiveTypesImpl() {
        }

        public ComparisonConfigurer toTreatDefaultValuesAs(PrimitiveDefaultValueMode mode) {
            ComparisonService.this.primitiveDefaultValueMode = mode;
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OfType
    extends AbstractOf {
        private final Class<?> type;

        public OfType(Class<?> type) {
            this.type = type;
        }

        @Override
        public ComparisonConfigurer toUse(ComparisonStrategy comparisonStrategy) {
            ComparisonService.this.typeComparisonStrategyMap.put(this.type, comparisonStrategy);
            return ComparisonService.this;
        }
    }
}

