/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.node;

import de.danielbechler.diff.node.AbstractFilteringVisitor;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.node.Visit;
import de.danielbechler.util.Collections;
import java.util.Collection;
import java.util.TreeSet;

public abstract class CategoryFilteringVisitor
extends AbstractFilteringVisitor {
    private final Collection<String> include = new TreeSet<String>();
    private final Collection<String> exclude = new TreeSet<String>();
    private boolean includeAllNonExcluded;

    protected boolean accept(DiffNode node) {
        if (this.isExcluded(node)) {
            return false;
        }
        return this.isIncluded(node) || this.includeAllNonExcluded;
    }

    protected void onDismiss(DiffNode node, Visit visit) {
        super.onDismiss(node, visit);
        visit.dontGoDeeper();
    }

    private boolean isExcluded(DiffNode node) {
        return Collections.containsAny(node.getCategories(), this.exclude);
    }

    private boolean isIncluded(DiffNode node) {
        return Collections.containsAny(node.getCategories(), this.include);
    }

    public final CategoryFilteringVisitor include(String category) {
        this.include.add(category);
        this.exclude.remove(category);
        return this;
    }

    public final CategoryFilteringVisitor includeOnly(String category) {
        this.include(category);
        this.includeAllNonExcluded(false);
        return this;
    }

    public final CategoryFilteringVisitor includeAllNonExcluded(boolean value) {
        this.includeAllNonExcluded = value;
        return this;
    }

    public final CategoryFilteringVisitor exclude(String category) {
        this.exclude.add(category);
        this.include.remove(category);
        return this;
    }
}

