/*
 * Decompiled with CFR 0.152.
 */
package org.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.List;
import org.geojson.GeoJsonObjectVisitor;
import org.geojson.Geometry;
import org.geojson.LngLatAlt;

public class Polygon
extends Geometry<List<LngLatAlt>> {
    public Polygon() {
    }

    public Polygon(List<LngLatAlt> polygon) {
        this.add(polygon);
    }

    public Polygon(LngLatAlt ... polygon) {
        this.add(Arrays.asList(polygon));
    }

    public void setExteriorRing(List<LngLatAlt> points) {
        if (this.coordinates.isEmpty()) {
            this.coordinates.add(0, points);
        } else {
            this.coordinates.set(0, points);
        }
    }

    @JsonIgnore
    public List<LngLatAlt> getExteriorRing() {
        this.assertExteriorRing();
        return (List)this.coordinates.get(0);
    }

    @JsonIgnore
    public List<List<LngLatAlt>> getInteriorRings() {
        this.assertExteriorRing();
        return this.coordinates.subList(1, this.coordinates.size());
    }

    public List<LngLatAlt> getInteriorRing(int index) {
        this.assertExteriorRing();
        return (List)this.coordinates.get(1 + index);
    }

    public void addInteriorRing(List<LngLatAlt> points) {
        this.assertExteriorRing();
        this.coordinates.add(points);
    }

    public void addInteriorRing(LngLatAlt ... points) {
        this.assertExteriorRing();
        this.coordinates.add(Arrays.asList(points));
    }

    private void assertExteriorRing() {
        if (this.coordinates.isEmpty()) {
            throw new RuntimeException("No exterior ring definied");
        }
    }

    @Override
    public <T> T accept(GeoJsonObjectVisitor<T> geoJsonObjectVisitor) {
        return geoJsonObjectVisitor.visit(this);
    }

    @Override
    public String toString() {
        return "Polygon{} " + super.toString();
    }
}

