/*
 * Decompiled with CFR 0.152.
 */
package org.osmtools.api;

import java.util.ArrayList;
import java.util.List;
import org.osm.schema.Osm;
import org.osmtools.api.OsmApiException;
import org.osmtools.oauth.OauthCredentials;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.social.oauth1.AbstractOAuth1ApiBinding;

public abstract class OsmApiBinding
extends AbstractOAuth1ApiBinding {
    protected String osmApiBaseUrl;

    public OsmApiBinding(String osmApiBaseUrl, OauthCredentials oauthCredentials) {
        super(oauthCredentials.getConsumerKey(), oauthCredentials.getConsumerSecret(), oauthCredentials.getAccessToken(), oauthCredentials.getAccessTokenSecret());
        this.osmApiBaseUrl = osmApiBaseUrl;
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        messageConverters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        return messageConverters;
    }

    protected long putForId(String url, Osm osm) {
        HttpEntity entity = new HttpEntity((Object)osm);
        ResponseEntity response = this.getRestTemplate().exchange(url, HttpMethod.PUT, entity, String.class, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK) {
            return Long.parseLong((String)response.getBody());
        }
        throw new OsmApiException(response.getStatusCode().getReasonPhrase());
    }

    protected void deleteForId(String url) {
        this.getRestTemplate().delete(url, new Object[0]);
    }
}

