/*
 * Decompiled with CFR 0.152.
 */
package org.osmtools.api;

import java.util.Collection;
import java.util.List;
import org.osm.schema.Osm;
import org.osm.schema.OsmNode;
import org.osm.schema.OsmRelation;
import org.osm.schema.OsmWay;
import org.osmtools.api.BoundingBox;
import org.osmtools.api.ChangesetOperations;
import org.osmtools.api.ChangesetTemplate;
import org.osmtools.api.OsmOperations;
import org.osmtools.api.OsmSchemaService;
import org.osmtools.api.UserOperations;
import org.osmtools.api.UserTemplate;
import org.osmtools.oauth.OauthCredentials;
import org.osmtools.oauth.OauthTokens;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class OsmTemplate
implements OsmOperations {
    @Autowired
    private OsmSchemaService osmSchemaService;
    @Autowired
    protected RestTemplate restTemplate;
    protected String osmApiBaseUrl;
    private OauthCredentials oauthCredentials;

    public OsmTemplate(String osmApiBaseUrl) {
        this.osmApiBaseUrl = osmApiBaseUrl;
    }

    public OsmTemplate(String osmApiBaseUrl, String consumerKey, String consumerSecret) {
        this.osmApiBaseUrl = osmApiBaseUrl;
        this.oauthCredentials = new OauthCredentials(consumerKey, consumerSecret);
    }

    @Override
    public Osm getBBox(BoundingBox boundingBox) {
        String url = this.osmApiBaseUrl + "/api/0.6/map?bbox=" + boundingBox.getWest() + "," + boundingBox.getSouth() + "," + boundingBox.getEast() + "," + boundingBox.getNorth();
        return (Osm)this.restTemplate.getForObject(url, Osm.class, new Object[0]);
    }

    @Override
    public ChangesetOperations openChangeset(String comment, OauthTokens oauthTokens) {
        Osm osm = this.osmSchemaService.createChangeset(comment);
        return new ChangesetTemplate(this.osmSchemaService, this.osmApiBaseUrl, osm, this.oauthCredentials.newInstance(oauthTokens.getToken(), oauthTokens.getTokenSecret()));
    }

    @Override
    public OsmNode getForNode(long nodeId) {
        String url = this.osmApiBaseUrl + "/api/0.6/node/" + nodeId;
        Osm osm = (Osm)this.restTemplate.getForObject(url, Osm.class, new Object[0]);
        return (OsmNode)osm.getNode().get(0);
    }

    @Override
    public OsmWay getForWay(long wayId) {
        String url = this.osmApiBaseUrl + "/api/0.6/way/" + wayId;
        Osm osm = (Osm)this.restTemplate.getForObject(url, Osm.class, new Object[0]);
        return (OsmWay)osm.getWay().get(0);
    }

    @Override
    public List<OsmWay> getForManyWays(Collection<Long> wayIds) {
        String url = this.osmApiBaseUrl + "/api/0.6/ways?ways=" + StringUtils.collectionToCommaDelimitedString(wayIds);
        Osm osm = (Osm)this.restTemplate.getForObject(url, Osm.class, new Object[0]);
        return osm.getWay();
    }

    @Override
    public List<OsmRelation> getForRelation(long relationId) {
        String url = this.osmApiBaseUrl + "/api/0.6/relation/" + relationId;
        Osm osm = (Osm)this.restTemplate.getForObject(url, Osm.class, new Object[0]);
        return osm.getRelation();
    }

    @Override
    public UserOperations userOperations(OauthTokens oauthTokens) {
        return new UserTemplate(this.osmApiBaseUrl, this.oauthCredentials.newInstance(oauthTokens.getToken(), oauthTokens.getTokenSecret()));
    }
}

