/*
 * Decompiled with CFR 0.152.
 */
package org.osmtools.oauth;

import javax.servlet.http.HttpServletResponse;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthProvider;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import org.apache.http.client.methods.HttpRequestBase;
import org.osmtools.oauth.OauthConfig;
import org.osmtools.oauth.OauthTokens;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Service;

@Service
@Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class OauthService
implements InitializingBean {
    private OAuthConsumer consumer;
    private OAuthProvider provider;
    private String callbackUrl;
    @Autowired
    private OauthConfig oauthConfig;

    public void afterPropertiesSet() throws Exception {
        this.consumer = new CommonsHttpOAuthConsumer(this.oauthConfig.getConsumerKey(), this.oauthConfig.getConsumerSecret());
        this.provider = new DefaultOAuthProvider(this.oauthConfig.getRequestTokenEndpointUrl(), this.oauthConfig.getAccessTokenEndpointUrl(), this.oauthConfig.getAuthorizeWebsiteUrl());
        this.callbackUrl = this.oauthConfig.getOauthCallbackUrl();
    }

    public String getRequestTokenUrl(HttpServletResponse response) {
        try {
            return this.provider.retrieveRequestToken(this.consumer, response.encodeURL(this.callbackUrl));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public OauthTokens retrieveAccessToken(String oauthVerifier) {
        try {
            this.provider.retrieveAccessToken(this.consumer, oauthVerifier);
            return new OauthTokens(this.consumer.getToken(), this.consumer.getTokenSecret());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public OAuthConsumer getConsumer() {
        return this.consumer;
    }

    public void signRequest(HttpRequestBase requestBase) {
        try {
            this.consumer.sign((Object)requestBase);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

