/*
 * Decompiled with CFR 0.152.
 */
package org.osmtools.taginfo;

import org.osmtools.taginfo.Pagination;
import org.osmtools.taginfo.TagInfoFilter;
import org.osmtools.taginfo.TagInfoSort;
import org.osmtools.taginfo.TagInfoSortOrder;

public class TagInfoUrlBuilder {
    private String baseUrl = "http://taginfo.openstreetmap.org/api/4";
    private String path;
    private StringBuilder params = new StringBuilder();

    public TagInfoUrlBuilder(String path) {
        this.path = path;
    }

    public TagInfoUrlBuilder append(String key, long value) {
        return this.append(key, String.valueOf(value));
    }

    public TagInfoUrlBuilder append(String key, String value) {
        if (this.params.length() != 0) {
            this.params.append('&');
        }
        this.params.append(key).append('=').append(value);
        return this;
    }

    public TagInfoUrlBuilder append(TagInfoSort sort, TagInfoSortOrder sortOrder) {
        if (sort != null) {
            this.append("sortname", sort.name().toLowerCase());
            this.append("sortorder", sortOrder.name().toLowerCase());
        }
        return this;
    }

    public TagInfoUrlBuilder append(Pagination pagination) {
        if (pagination != null) {
            this.append("page", pagination.getPage()).append("rp", pagination.getResultsPerPage());
        }
        return this;
    }

    public TagInfoUrlBuilder append(TagInfoFilter filter) {
        if (filter != null && filter != TagInfoFilter.ALL) {
            this.append("filter", filter.name().toLowerCase());
        }
        return this;
    }

    public String toString() {
        StringBuilder url = new StringBuilder(this.baseUrl);
        url.append(this.path);
        if (this.params.length() > 0) {
            url.append('?').append((CharSequence)this.params);
        }
        return url.toString();
    }
}

