/*
 * Decompiled with CFR 0.152.
 */
package org.osmtools.utils;

import java.util.List;
import org.osmtools.utils.GeoPoint;

public class Centroid {
    private List<GeoPoint> points;
    private int uniquePoints;

    public Centroid(List<GeoPoint> points) {
        this.points = points;
        this.uniquePoints = points.size() - 1;
    }

    public double area() {
        return Math.abs(this.signedArea());
    }

    public double signedArea() {
        double sum = 0.0;
        for (int i = 0; i < this.uniquePoints; ++i) {
            sum = sum + this.points.get((int)i).x * this.points.get((int)(i + 1)).y - this.points.get((int)i).y * this.points.get((int)(i + 1)).x;
        }
        return 0.5 * sum;
    }

    public GeoPoint centroid() {
        double cx = 0.0;
        double cy = 0.0;
        for (int i = 0; i < this.uniquePoints; ++i) {
            cx += (this.points.get((int)i).x + this.points.get((int)(i + 1)).x) * (this.points.get((int)i).y * this.points.get((int)(i + 1)).x - this.points.get((int)i).x * this.points.get((int)(i + 1)).y);
            cy += (this.points.get((int)i).y + this.points.get((int)(i + 1)).y) * (this.points.get((int)i).y * this.points.get((int)(i + 1)).x - this.points.get((int)i).x * this.points.get((int)(i + 1)).y);
        }
        return new GeoPoint(Math.abs(cx /= 6.0 * this.area()), Math.abs(cy /= 6.0 * this.area()));
    }
}

