/*
 * Decompiled with CFR 0.152.
 */
package org.osmtools.utils;

import org.osmtools.api.LonLat;

public class LonLatMath {
    private static int[] sinTable = new int[201];
    private static int[] cosTable = new int[201];
    private static final double LAT_DEGEE_DISTANCE = 110.52252209944751;
    private static final double LONG_DEGEE_DISTANCE = 111.32386666666666;

    public static int round(double d) {
        return (int)new Double(Math.floor(d + 0.5)).longValue();
    }

    public static double rotateX(double x, double y, double sin, double cos) {
        return cos * x + sin * y;
    }

    public static double rotateY(double x, double y, double sin, double cos) {
        return -sin * x + cos * y;
    }

    public static double distance(LonLat lonLat1, LonLat lonLat2) {
        return LonLatMath.distance(lonLat1.getLon(), lonLat1.getLat(), lonLat2.getLon(), lonLat2.getLat());
    }

    public static double distance(double long1, double lat1, double long2, double lat2) {
        double latDistance = Math.abs(lat1 - lat2) * 110.52252209944751;
        double longDistance = Math.abs(long1 - long2) * Math.cos(Math.toRadians(Math.max(lat1, lat2) - Math.abs(lat1 - lat2))) * 111.32386666666666;
        return Math.sqrt(latDistance * latDistance + longDistance * longDistance);
    }

    public static double asin(double d) {
        return (double)sinTable[LonLatMath.round(d * 100.0) + 100] / 100.0;
    }

    public static double acos(double d) {
        return (double)cosTable[LonLatMath.round(d * 100.0) + 100] / 100.0;
    }

    public static double checkpointDirection(double cpLong, double cpLat, double posLong, double posLat) {
        double latDistance = Math.abs(cpLat - posLat) * 110.52252209944751;
        double longDistance = Math.abs(cpLong - posLong) * Math.cos(Math.toRadians(Math.max(cpLat, posLat) - Math.abs(cpLat - posLat))) * 111.32386666666666;
        double hypo = Math.sqrt(latDistance * latDistance + longDistance * longDistance);
        double sin = longDistance / hypo;
        double raddeg = LonLatMath.asin(sin);
        if (cpLat < posLat) {
            if (cpLong > posLong) {
                return Math.PI - raddeg;
            }
            return raddeg + Math.PI;
        }
        if (cpLong > posLong) {
            return raddeg;
        }
        return Math.PI * 2 - raddeg;
    }

    static {
        int x = -157;
        while (x <= 157) {
            int pos = LonLatMath.round(Math.sin((double)x / 100.0) * 100.0);
            LonLatMath.sinTable[pos + 100] = x;
            pos = LonLatMath.round(Math.cos((double)x / 100.0) * 100.0);
            LonLatMath.cosTable[pos + 100] = x++;
        }
    }
}

