/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces.component.molplugin;

import java.io.Serializable;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class MolPluginCore
extends UIInput
implements ComponentSystemEventListener {
    private static final String RESOURCES_LIBRARY_NAME = "molecularfaces";
    public static final String COMPONENT_FAMILY = "molecularfaces.MolPluginFamily";
    public static final String DEFAULT_FORMAT = Format.MDLV2000.toString();
    public static final int DEFAULT_HEIGHT = 400;
    public static final int DEFAULT_WIDTH = 400;
    private Set<String> scriptResourcesToLoad = new HashSet<String>();
    private Set<String> scriptsExtToLoad = new HashSet<String>();
    private Set<String> cssResourcesToLoad = new HashSet<String>();
    private Set<String> cssExtToLoad = new HashSet<String>();

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public boolean isBorder() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.border), (Object)false);
    }

    public void setBorder(boolean border) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.border), (Object)border);
    }

    public String getFormat() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.format), (Object)DEFAULT_FORMAT);
    }

    public void setFormat(String format) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.format), (Object)format);
    }

    public int getHeight() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.height), (Object)400);
    }

    public void setHeight(int height) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.height), (Object)height);
    }

    public boolean isReadonly() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.readonly), (Object)false);
    }

    public void setReadonly(boolean readonly) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.readonly), (Object)readonly);
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar));
    }

    public void setWidgetVar(String widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)widgetVar);
    }

    public int getWidth() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.width), (Object)400);
    }

    public void setWidth(int width) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.width), (Object)width);
    }

    protected void addScriptResource(String resource) {
        this.scriptResourcesToLoad.add(resource);
    }

    protected void addScriptExt(String src) {
        this.scriptsExtToLoad.add(src);
    }

    protected void addCssResource(String resource) {
        this.cssResourcesToLoad.add(resource);
    }

    protected void addCssExt(String href) {
        this.cssExtToLoad.add(href);
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (event instanceof PostAddToViewEvent) {
            for (String resource : this.scriptResourcesToLoad) {
                UIOutput jsResource = new UIOutput();
                jsResource.setRendererType("javax.faces.resource.Script");
                jsResource.getAttributes().put("library", RESOURCES_LIBRARY_NAME);
                jsResource.getAttributes().put("name", resource);
                this.getFacesContext().getViewRoot().addComponentResource(this.getFacesContext(), (UIComponent)jsResource, "head");
            }
            for (String resource : this.cssResourcesToLoad) {
                UIOutput cssResource = new UIOutput();
                cssResource.setRendererType("javax.faces.resource.Stylesheet");
                cssResource.getAttributes().put("library", RESOURCES_LIBRARY_NAME);
                cssResource.getAttributes().put("name", resource);
                this.getFacesContext().getViewRoot().addComponentResource(this.getFacesContext(), (UIComponent)cssResource, "head");
            }
            this.processPostAddToViewEvent();
        }
        super.processEvent(event);
    }

    protected void processPostAddToViewEvent() {
    }

    protected StringBuilder encodeLoadExtResources(String loaderJSVar) {
        if (this.scriptsExtToLoad.isEmpty() && this.cssExtToLoad.isEmpty()) {
            return new StringBuilder();
        }
        StringBuilder sb = new StringBuilder(256);
        Formatter fmt = new Formatter(sb);
        sb.append(loaderJSVar);
        for (String script : this.scriptsExtToLoad) {
            fmt.format(".addScriptToHead(\"%s\")", script);
        }
        for (String href : this.cssExtToLoad) {
            fmt.format(".addCssToHead(\"%s\")", href);
        }
        sb.append(";");
        fmt.close();
        return sb;
    }

    protected static enum PropertyKeys {
        border,
        format,
        height,
        readonly,
        widgetVar,
        width;

    }

    public static enum Format {
        MDLV2000,
        MDLV3000;


        public String toString() {
            return this.name();
        }
    }

    public static enum PluginType {
        OpenChemLibJS,
        MolPaintJS,
        MarvinJS;


        public String toString() {
            return this.name();
        }
    }
}

