/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces.component.molplugin;

import de.ipb_halle.molecularfaces.component.molplugin.MolPluginCore;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;

public abstract class MolPluginRenderer
extends Renderer {
    public void decode(FacesContext context, UIComponent component) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        MolPluginCore plugin = (MolPluginCore)component;
        if (!plugin.isReadonly()) {
            String clientId = plugin.getClientId(context);
            String value = (String)requestMap.get(clientId);
            plugin.setSubmittedValue(value);
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Converter converter;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (submittedValue instanceof String && component instanceof MolPluginCore && (converter = ((MolPluginCore)component).getConverter()) != null) {
            return converter.getAsObject(context, component, (String)submittedValue);
        }
        return submittedValue;
    }

    protected String getValueAsString(FacesContext context, MolPluginCore component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter.getAsString(context, (UIComponent)component, component.getValue());
        }
        return (String)component.getValue();
    }

    protected static String generateDivStyle(MolPluginCore plugin) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("width:").append(plugin.getWidth()).append("px;");
        sb.append("height:").append(plugin.getHeight()).append("px;");
        if (plugin.isBorder()) {
            sb.append("border:solid;border-width:1px;");
        }
        return sb.toString();
    }
}

