/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces.component.molplugin;

import de.ipb_halle.molecularfaces.component.molplugin.MolPluginCore;
import de.ipb_halle.molecularfaces.component.molplugin.MolPluginRenderer;
import java.io.IOException;
import java.util.Formatter;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(rendererType="molecularfaces.OpenChemLibJSRenderer", componentFamily="molecularfaces.MolPluginFamily")
public class OpenChemLibJSRenderer
extends MolPluginRenderer {
    public static final String RENDERER_TYPE = "molecularfaces.OpenChemLibJSRenderer";
    private String loaderJSVar = "molecularfaces.openChemLibJSLoaderInstance";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        MolPluginCore plugin = (MolPluginCore)component;
        if (!plugin.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)plugin.getClientId(), null);
        if (plugin.isReadonly()) {
            this.encodeViewer(context, writer, plugin);
        } else {
            this.encodeEditor(context, writer, plugin);
        }
        writer.endElement("div");
    }

    private void encodeViewer(FacesContext context, ResponseWriter writer, MolPluginCore plugin) throws IOException {
        String clientId = plugin.getClientId();
        String hiddenInputId = clientId + "_Input";
        String divId = clientId + "_OpenChemLibJSViewer";
        this.encodeViewerHTML(context, writer, plugin, divId, hiddenInputId);
        this.encodeViewerJS(writer, plugin, divId, hiddenInputId);
    }

    private void encodeViewerHTML(FacesContext context, ResponseWriter writer, MolPluginCore plugin, String divId, String hiddenInputId) throws IOException {
        writer.startElement("div", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)divId, null);
        writer.writeAttribute("style", (Object)OpenChemLibJSRenderer.generateDivStyle(plugin), null);
        writer.endElement("div");
        writer.startElement("input", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)hiddenInputId, null);
        writer.writeAttribute("value", (Object)this.getValueAsString(context, plugin), "value");
        writer.endElement("input");
    }

    private void encodeViewerJS(ResponseWriter writer, MolPluginCore plugin, String divId, String hiddenInputId) throws IOException {
        writer.startElement("script", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuilder sb = new StringBuilder(512);
        sb.append((CharSequence)plugin.encodeLoadExtResources(this.loaderJSVar));
        Formatter fmt = new Formatter(sb);
        String widgetVar = plugin.getWidgetVar();
        if (widgetVar != null && !widgetVar.isEmpty()) {
            fmt.format("var %s = ", widgetVar);
        }
        fmt.format("%s.status().then(() => {", this.loaderJSVar);
        fmt.format("return molecularfaces.OpenChemLibJSViewer.newViewer(\"%s\", document.getElementById(\"%s\").getAttribute(\"value\"), %d, %d);", divId, hiddenInputId, plugin.getHeight(), plugin.getWidth());
        fmt.close();
        sb.append("});");
        writer.writeText((Object)sb, null);
        writer.endElement("script");
    }

    private void encodeEditor(FacesContext context, ResponseWriter writer, MolPluginCore plugin) throws IOException {
        String clientId = plugin.getClientId();
        String hiddenInputId = clientId + "_Input";
        String divId = clientId + "_OpenChemLibJSEditor";
        this.encodeEditorHTML(context, writer, plugin, divId, hiddenInputId);
        this.encodeEditorJS(writer, plugin, divId, hiddenInputId);
    }

    private void encodeEditorHTML(FacesContext context, ResponseWriter writer, MolPluginCore plugin, String divId, String hiddenInputId) throws IOException {
        writer.startElement("div", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)divId, null);
        writer.writeAttribute("style", (Object)OpenChemLibJSRenderer.generateDivStyle(plugin), null);
        writer.endElement("div");
        writer.startElement("input", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)hiddenInputId, null);
        writer.writeAttribute("name", (Object)plugin.getClientId(), null);
        writer.writeAttribute("value", (Object)this.getValueAsString(context, plugin), "value");
        writer.endElement("input");
    }

    private void encodeEditorJS(ResponseWriter writer, MolPluginCore plugin, String divId, String hiddenInputId) throws IOException {
        writer.startElement("script", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuilder sb = new StringBuilder(512);
        sb.append((CharSequence)plugin.encodeLoadExtResources(this.loaderJSVar));
        Formatter fmt = new Formatter(sb);
        String widgetVar = plugin.getWidgetVar();
        if (widgetVar != null && !widgetVar.isEmpty()) {
            fmt.format("var %s = ", widgetVar);
        }
        fmt.format("%s.status().then(() => {", this.loaderJSVar);
        fmt.format("return molecularfaces.OpenChemLibJSEditor.newEditor(\"%s\", document.getElementById(\"%s\").getAttribute(\"value\"), \"%s\")", divId, hiddenInputId, plugin.getFormat());
        fmt.format(".then((editor) => editor.addChangeListener((mol) => { document.getElementById(\"%s\").setAttribute(\"value\", mol); }));", hiddenInputId);
        fmt.close();
        sb.append("});");
        writer.writeText((Object)sb, null);
        writer.endElement("script");
    }
}

