/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces.converter;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.MDLV2000Writer;

@FacesConverter(value="molecularfaces.MDLV2000Converter")
public class MDLV2000Converter
implements Converter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IAtomContainer getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        if (value == null) return null;
        if (value.isEmpty()) {
            return null;
        }
        try (MDLV2000Reader reader = new MDLV2000Reader((Reader)new StringReader(value));){
            IAtomContainer iAtomContainer = (IAtomContainer)reader.read((IChemObject)new AtomContainer());
            return iAtomContainer;
        }
        catch (Exception e) {
            throw new ConverterException(new FacesMessage(e.getMessage()), (Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        if (value == null || !(value instanceof IAtomContainer)) {
            return "";
        }
        IAtomContainer mol = (IAtomContainer)value;
        StringWriter writer = new StringWriter();
        try (MDLV2000Writer molWriter = new MDLV2000Writer((Writer)writer);){
            molWriter.write((IChemObject)mol);
        }
        catch (Exception e) {
            throw new ConverterException(new FacesMessage(e.getMessage()), (Throwable)e);
        }
        return writer.toString();
    }
}

