/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces.util;

import java.util.Map;
import java.util.Objects;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class RendererUtils {
    private RendererUtils() {
    }

    public static void decodeComponent(FacesContext context, UIInput component) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(component);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(context);
        String value = (String)requestMap.get(clientId);
        component.setSubmittedValue((Object)value);
    }

    public static Object convertSubmittedValueToObject(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        UIInput inputComponent;
        Converter converter;
        Objects.requireNonNull(context);
        Objects.requireNonNull(component);
        if (submittedValue instanceof String && component instanceof UIInput && (converter = (inputComponent = (UIInput)component).getConverter()) != null) {
            return converter.getAsObject(context, (UIComponent)inputComponent, (String)submittedValue);
        }
        return submittedValue;
    }

    public static String convertValueToString(FacesContext context, UIInput component, Object value) throws ConverterException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(component);
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter.getAsString(context, (UIComponent)component, value);
        }
        return (String)value;
    }
}

