/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.flac;

import de.jarnbjo.flac.FlacFormatException;
import de.jarnbjo.flac.MetadataBlock;
import de.jarnbjo.flac.SeekPoint;
import de.jarnbjo.util.io.BitInputStream;
import java.io.IOException;

public class SeekTable
extends MetadataBlock {
    private SeekPoint[] seekPoints;

    protected SeekTable(BitInputStream source) throws FlacFormatException, IOException {
        int length = source.getInt(24);
        if (length % 18 != 0) {
            throw new FlacFormatException("SEEKTABLE header length not dividible by 18");
        }
        int points = length / 18;
        this.seekPoints = new SeekPoint[points];
        for (int i = 0; i < points; ++i) {
            long l1 = source.getLong(64);
            long l2 = source.getLong(64);
            int i3 = source.getInt(16);
            this.seekPoints[i] = new SeekPoint(l1, l2, i3);
        }
    }
}

