/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.vorbis;

import de.jarnbjo.vorbis.Floor;

public final class Util {
    public static final int ilog(int x) {
        int res = 0;
        while (x > 0) {
            x >>= 1;
            ++res;
        }
        return res;
    }

    public static final float float32unpack(int x) {
        float mantissa = x & 0x1FFFFF;
        float e = (x & 0x7FE00000) >> 21;
        if ((x & Integer.MIN_VALUE) != 0) {
            mantissa = -mantissa;
        }
        return mantissa * (float)Math.pow(2.0, (double)e - 788.0);
    }

    public static final int lookup1Values(int a, int b) {
        int res = (int)Math.pow(Math.E, Math.log(a) / (double)b);
        return Util.intPow(res + 1, b) <= a ? res + 1 : res;
    }

    public static final int intPow(int base, int e) {
        int res = 1;
        while (e > 0) {
            --e;
            res *= base;
        }
        return res;
    }

    public static final boolean isBitSet(int value, int bit) {
        return (value & 1 << bit) != 0;
    }

    public static final int icount(int value) {
        int res = 0;
        while (value > 0) {
            res += value & 1;
            value >>= 1;
        }
        return res;
    }

    public static final int lowNeighbour(int[] v, int x) {
        int max = -1;
        int n = 0;
        for (int i = 0; i < v.length && i < x; ++i) {
            if (v[i] <= max || v[i] >= v[x]) continue;
            max = v[i];
            n = i;
        }
        return n;
    }

    public static final int highNeighbour(int[] v, int x) {
        int min = Integer.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < v.length && i < x; ++i) {
            if (v[i] >= min || v[i] <= v[x]) continue;
            min = v[i];
            n = i;
        }
        return n;
    }

    public static final int renderPoint(int x0, int x1, int y0, int y1, int x) {
        int dy = y1 - y0;
        int ady = dy < 0 ? -dy : dy;
        int off = ady * (x - x0) / (x1 - x0);
        return dy < 0 ? y0 - off : y0 + off;
    }

    public static final void renderLine(int x0, int y0, int x1, int y1, float[] v) {
        int dy = y1 - y0;
        int adx = x1 - x0;
        int base = dy / adx;
        int sy = dy < 0 ? base - 1 : base + 1;
        int x = x0;
        int y = y0;
        int err = 0;
        int ady = (dy < 0 ? -dy : dy) - (base > 0 ? base * adx : -base * adx);
        int n = x;
        v[n] = v[n] * Floor.DB_STATIC_TABLE[y];
        for (x = x0 + 1; x < x1; ++x) {
            if ((err += ady) >= adx) {
                err -= adx;
                int n2 = x;
                v[n2] = v[n2] * Floor.DB_STATIC_TABLE[y += sy];
                continue;
            }
            int n3 = x;
            v[n3] = v[n3] * Floor.DB_STATIC_TABLE[y += base];
        }
    }
}

