/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import de.javakaffee.web.msm.serializer.kryo.SerializerFactory;

public class HibernateCollectionsSerializerFactory
implements SerializerFactory {
    private static Class<?> HIBERNATE_ABSTRACT_COLLECTION_CLASS;
    private final Kryo _kryo;

    public HibernateCollectionsSerializerFactory(Kryo kryo) {
        this._kryo = kryo;
    }

    @Override
    public Serializer newSerializer(Class<?> type) {
        if (HIBERNATE_ABSTRACT_COLLECTION_CLASS == null) {
            return null;
        }
        if (HIBERNATE_ABSTRACT_COLLECTION_CLASS.isAssignableFrom(type)) {
            return new FieldSerializer(this._kryo, type);
        }
        return null;
    }

    static {
        try {
            HIBERNATE_ABSTRACT_COLLECTION_CLASS = Class.forName("org.hibernate.collection.AbstractPersistentCollection");
        }
        catch (ClassNotFoundException e) {
            try {
                HIBERNATE_ABSTRACT_COLLECTION_CLASS = Class.forName("org.hibernate.collection.internal.AbstractPersistentCollection");
            }
            catch (ClassNotFoundException e2) {
                HIBERNATE_ABSTRACT_COLLECTION_CLASS = null;
            }
        }
    }
}

