/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j;

import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.expression.ExpressionHandler;
import de.neuland.jade4j.expression.JexlExpressionHandler;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.Parser;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.template.FileTemplateLoader;
import de.neuland.jade4j.template.JadeTemplate;
import de.neuland.jade4j.template.ReaderTemplateLoader;
import de.neuland.jade4j.template.TemplateLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;

public class Jade4J {
    public static String render(String filename, Map<String, Object> model) throws IOException, JadeCompilerException {
        return Jade4J.render(filename, model, false);
    }

    public static String render(String filename, Map<String, Object> model, boolean pretty) throws IOException, JadeCompilerException {
        JadeTemplate template = Jade4J.getTemplate(filename);
        template.setPrettyPrint(pretty);
        return Jade4J.templateToString(template, model);
    }

    public static void render(String filename, Map<String, Object> model, Writer writer) throws IOException, JadeCompilerException {
        Jade4J.render(filename, model, writer, false);
    }

    public static void render(String filename, Map<String, Object> model, Writer writer, boolean pretty) throws IOException, JadeCompilerException {
        JadeTemplate template = Jade4J.getTemplate(filename);
        template.setPrettyPrint(pretty);
        template.process(new JadeModel(model), writer);
    }

    public static String render(JadeTemplate template, Map<String, Object> model) throws JadeCompilerException {
        return Jade4J.render(template, model, false);
    }

    public static String render(JadeTemplate template, Map<String, Object> model, boolean pretty) throws JadeCompilerException {
        template.setPrettyPrint(pretty);
        return Jade4J.templateToString(template, model);
    }

    public static void render(JadeTemplate template, Map<String, Object> model, Writer writer) throws JadeCompilerException {
        Jade4J.render(template, model, writer, false);
    }

    public static void render(JadeTemplate template, Map<String, Object> model, Writer writer, boolean pretty) throws JadeCompilerException {
        template.setPrettyPrint(pretty);
        template.process(new JadeModel(model), writer);
    }

    public static String render(URL url, Map<String, Object> model) throws IOException, JadeCompilerException {
        return Jade4J.render(url, model, false);
    }

    public static String render(URL url, Map<String, Object> model, boolean pretty) throws IOException, JadeCompilerException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        JadeTemplate template = Jade4J.getTemplate(reader, url.getPath());
        return Jade4J.render(template, model, pretty);
    }

    public static String render(Reader reader, String filename, Map<String, Object> model) throws IOException, JadeCompilerException {
        return Jade4J.render(reader, filename, model, false);
    }

    public static String render(Reader reader, String filename, Map<String, Object> model, boolean pretty) throws IOException, JadeCompilerException {
        JadeTemplate template = Jade4J.getTemplate(reader, filename);
        return Jade4J.render(template, model, pretty);
    }

    public static JadeTemplate getTemplate(String filename) throws IOException {
        return Jade4J.createTemplate(filename, "", new FileTemplateLoader("", "UTF-8"), new JexlExpressionHandler());
    }

    private static JadeTemplate getTemplate(Reader reader, String name) throws IOException {
        return Jade4J.createTemplate(name, "", new ReaderTemplateLoader(reader, name), new JexlExpressionHandler());
    }

    private static JadeTemplate createTemplate(String filename, String basePath, TemplateLoader loader, ExpressionHandler expressionHandler) throws IOException {
        Parser parser = new Parser(filename, basePath, loader, expressionHandler);
        Node root = parser.parse();
        JadeTemplate template = new JadeTemplate();
        template.setExpressionHandler(expressionHandler);
        template.setTemplateLoader(loader);
        template.setRootNode(root);
        return template;
    }

    private static String templateToString(JadeTemplate template, Map<String, Object> model) throws JadeCompilerException {
        JadeModel jadeModel = new JadeModel(model);
        StringWriter writer = new StringWriter();
        template.process(jadeModel, writer);
        return writer.toString();
    }

    public static enum Mode {
        HTML,
        XML,
        XHTML;

    }
}

