/*
 * Decompiled with CFR 0.152.
 */
package de.roskenet.jfxsupport.test;

import de.felixroske.jfxsupport.AbstractFxmlView;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.assertj.core.util.Preconditions;
import org.junit.BeforeClass;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.testfx.framework.junit.ApplicationTest;

public class GuiTest
extends ApplicationTest
implements ApplicationContextAware {
    public static boolean headless;
    public static String geometry;
    private ApplicationContext appCtx;
    private AbstractFxmlView viewBean;

    @BeforeClass
    public static void setHeadlessMode() {
        String headlessProp = System.getProperty("JAVAFX_HEADLESS", "true");
        Boolean headless = Boolean.valueOf(headlessProp);
        String geometryProp = System.getProperty("JAVAFX_GEOMETRY", "1600x1200-32");
        if (headless.booleanValue()) {
            System.setProperty("testfx.robot", "glass");
            System.setProperty("testfx.headless", "true");
            System.setProperty("prism.order", "sw");
            System.setProperty("java.awt.headless", "true");
            System.setProperty("headless.geometry", geometryProp);
        } else {
            System.setProperty("java.awt.headless", "false");
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = applicationContext;
    }

    protected void init(Class<? extends AbstractFxmlView> viewClass) throws Exception {
        super.init();
        this.viewBean = (AbstractFxmlView)this.appCtx.getBean(viewClass);
    }

    protected void init(AbstractFxmlView viewBean) throws Exception {
        super.init();
        this.viewBean = viewBean;
    }

    public <T extends Node> T find(String query) {
        return (T)this.lookup(query).query();
    }

    public void start(Stage stage) throws Exception {
        Preconditions.checkNotNull((Object)this.viewBean, (String)"No view to set up! Have you called init() before?");
        Scene scene = this.viewBean.getView().getScene();
        if (scene == null) {
            Scene x = new Scene(this.viewBean.getView());
            stage.setScene(x);
        } else {
            stage.setScene(scene);
        }
        stage.show();
    }
}

