/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DColorMapper;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DFontTextDrawer;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DImageEncoder;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DPaintApplier;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DColorMapper;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DFontTextDrawer;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DLosslessImageEncoder;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DPaintApplier;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.util.Matrix;

public class PdfBoxGraphics2D
extends Graphics2D {
    private final PDFormXObject xFormObject;
    private final Graphics2D calcGfx;
    private final PDPageContentStream contentStream;
    private BufferedImage calcImage;
    private PDDocument document;
    private final AffineTransform baseTransform;
    private AffineTransform transform = new AffineTransform();
    private IPdfBoxGraphics2DImageEncoder imageEncoder = new PdfBoxGraphics2DLosslessImageEncoder();
    private IPdfBoxGraphics2DColorMapper colorMapper = new PdfBoxGraphics2DColorMapper();
    private IPdfBoxGraphics2DPaintApplier paintApplier = new PdfBoxGraphics2DPaintApplier();
    private IPdfBoxGraphics2DFontTextDrawer fontTextDrawer = new PdfBoxGraphics2DFontTextDrawer();
    private Paint paint;
    private Stroke stroke;
    private Color xorColor;
    private Font font;
    private Composite composite;
    private Shape clipShape;
    private Color backgroundColor;
    private final CopyInfo copyInfo;
    private final PDRectangle bbox;
    private int saveCounter = 0;
    private final List<CopyInfo> copyList = new ArrayList<CopyInfo>();
    private Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();

    public void setColorMapper(IPdfBoxGraphics2DColorMapper colorMapper) {
        this.colorMapper = colorMapper;
    }

    public void setImageEncoder(IPdfBoxGraphics2DImageEncoder imageEncoder) {
        this.imageEncoder = imageEncoder;
    }

    public void setPaintApplier(IPdfBoxGraphics2DPaintApplier paintApplier) {
        this.paintApplier = paintApplier;
    }

    public PdfBoxGraphics2D(PDDocument document, int pixelWidth, int pixelHeight) throws IOException {
        this(document, new PDRectangle((float)pixelWidth, (float)pixelHeight));
    }

    public PdfBoxGraphics2D(PDDocument document, float pixelWidth, float pixelHeight) throws IOException {
        this(document, new PDRectangle(pixelWidth, pixelHeight));
    }

    public void setFontTextDrawer(IPdfBoxGraphics2DFontTextDrawer fontTextDrawer) {
        this.fontTextDrawer = fontTextDrawer;
    }

    public PdfBoxGraphics2D(PDDocument document, PDRectangle bbox) throws IOException {
        this(document, bbox, null);
    }

    PdfBoxGraphics2D(PDDocument document, PDRectangle bbox, PdfBoxGraphics2D parentGfx) throws IOException {
        this.document = document;
        this.bbox = bbox;
        PDAppearanceStream appearance = new PDAppearanceStream(document);
        this.xFormObject = appearance;
        this.xFormObject.setResources(new PDResources());
        this.xFormObject.setBBox(bbox);
        this.contentStream = new PDPageContentStream(document, appearance, this.xFormObject.getStream().createOutputStream(COSName.FLATE_DECODE));
        this.contentStreamSaveState();
        if (parentGfx != null) {
            this.colorMapper = parentGfx.colorMapper;
            this.fontTextDrawer = parentGfx.fontTextDrawer;
            this.imageEncoder = parentGfx.imageEncoder;
            this.paintApplier = parentGfx.paintApplier;
        }
        this.baseTransform = new AffineTransform();
        this.baseTransform.translate(0.0, bbox.getHeight());
        this.baseTransform.scale(1.0, -1.0);
        this.calcImage = new BufferedImage(100, 100, 6);
        this.calcGfx = this.calcImage.createGraphics();
        this.font = this.calcGfx.getFont();
        this.copyInfo = null;
    }

    public PDFormXObject getXFormObject() {
        if (this.document != null) {
            throw new IllegalStateException("You can only get the XformObject after you disposed the Graphics2D!");
        }
        if (this.copyInfo != null) {
            throw new IllegalStateException("You can not get the Xform stream from the copy");
        }
        return this.xFormObject;
    }

    private PdfBoxGraphics2D(PdfBoxGraphics2D gfx) throws IOException {
        CopyInfo info = new CopyInfo();
        info.copy = this;
        info.sourceGfx = gfx;
        gfx.copyList.add(info);
        this.copyInfo = info;
        this.document = gfx.document;
        this.bbox = gfx.bbox;
        this.xFormObject = gfx.xFormObject;
        this.contentStream = gfx.contentStream;
        this.baseTransform = gfx.baseTransform;
        this.transform = (AffineTransform)gfx.transform.clone();
        this.calcGfx = gfx.calcGfx;
        this.calcImage = gfx.calcImage;
        this.font = gfx.font;
        this.stroke = gfx.stroke;
        this.paint = gfx.paint;
        this.clipShape = gfx.clipShape;
        this.backgroundColor = gfx.backgroundColor;
        this.colorMapper = gfx.colorMapper;
        this.fontTextDrawer = gfx.fontTextDrawer;
        this.imageEncoder = gfx.imageEncoder;
        this.paintApplier = gfx.paintApplier;
        this.composite = gfx.composite;
        this.renderingHints = new HashMap<RenderingHints.Key, Object>(gfx.renderingHints);
        this.xorColor = gfx.xorColor;
        this.saveCounter = 0;
        this.contentStreamSaveState();
    }

    @Override
    public void dispose() {
        if (this.copyInfo != null) {
            this.copyInfo.sourceGfx.copyList.remove(this.copyInfo);
            try {
                this.contentStreamRestoreState();
            }
            catch (IOException e) {
                this.throwException(e);
            }
            if (this.saveCounter != 0) {
                throw new IllegalStateException("Copy - SaveCounter should be 0, but is " + this.saveCounter);
            }
            return;
        }
        if (this.copyList.size() > 0) {
            throw new RuntimeException("Not all PdfGraphics2D copies were destroyed! Please ensure that all create() calls get a matching dispose() on the returned copies.");
        }
        try {
            this.contentStreamRestoreState();
            this.contentStream.close();
        }
        catch (IOException e) {
            this.throwException(e);
        }
        if (this.saveCounter != 0) {
            throw new IllegalStateException("SaveCounter should be 0, but is " + this.saveCounter);
        }
        this.document = null;
        this.calcGfx.dispose();
        this.calcImage.flush();
        this.calcImage = null;
    }

    @Override
    public void draw(Shape s) {
        try {
            this.contentStreamSaveState();
            PDShading pdShading = this.applyPaint();
            if (pdShading != null) {
                this.applyShadingAsColor(pdShading);
            }
            if (this.stroke instanceof BasicStroke) {
                BasicStroke basicStroke = (BasicStroke)this.stroke;
                this.contentStream.setLineCapStyle(basicStroke.getEndCap());
                this.contentStream.setLineJoinStyle(basicStroke.getLineJoin());
                if (basicStroke.getMiterLimit() > 0.0f) {
                    this.contentStream.setMiterLimit(basicStroke.getMiterLimit());
                }
                AffineTransform tf = new AffineTransform();
                tf.concatenate(this.baseTransform);
                tf.concatenate(this.transform);
                double scaleX = tf.getScaleX();
                this.contentStream.setLineWidth((float)Math.abs((double)basicStroke.getLineWidth() * scaleX));
                float[] dashArray = basicStroke.getDashArray();
                if (dashArray != null) {
                    for (int i = 0; i < dashArray.length; ++i) {
                        dashArray[i] = (float)Math.abs((double)dashArray[i] * scaleX);
                    }
                    this.contentStream.setLineDashPattern(dashArray, (float)Math.abs((double)basicStroke.getDashPhase() * scaleX));
                }
            }
            this.walkShape(s);
            this.contentStream.stroke();
            this.contentStreamRestoreState();
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage img1 = op.filter(img, null);
        this.drawImage(img1, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        WritableRaster data = img.copyData(null);
        this.drawImage(new BufferedImage(img.getColorModel(), data, false, null), xform, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        AttributedString attributedString = new AttributedString(str);
        attributedString.addAttribute(TextAttribute.FONT, this.font);
        this.drawString(attributedString.getIterator(), x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        AffineTransform tf = new AffineTransform();
        tf.translate(x, y);
        tf.scale((float)width / (float)img.getWidth(null), (float)height / (float)img.getHeight(null));
        return this.drawImage(img, tf, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        try {
            if (bgcolor != null) {
                this.contentStream.setNonStrokingColor(this.colorMapper.mapColor(this.contentStream, bgcolor));
                this.walkShape(new Rectangle(x, y, width, height));
                this.contentStream.fill();
            }
            return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
        }
        catch (IOException e) {
            this.throwException(e);
            return false;
        }
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy2, sx2, sy2, null, observer);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        this.checkNoCopyActive();
        AffineTransform tf = new AffineTransform();
        tf.concatenate(this.baseTransform);
        tf.concatenate(this.transform);
        tf.concatenate((AffineTransform)xform.clone());
        PDImageXObject pdImage = this.imageEncoder.encodeImage(this.document, this.contentStream, img);
        try {
            this.contentStreamSaveState();
            int imgHeight = img.getHeight(obs);
            tf.translate(0.0, imgHeight);
            tf.scale(1.0, -1.0);
            this.contentStream.transform(new Matrix(tf));
            Object keyInterpolation = this.renderingHints.get(RenderingHints.KEY_INTERPOLATION);
            if (RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR.equals(keyInterpolation)) {
                pdImage.setInterpolate(false);
            }
            this.contentStream.drawImage(pdImage, 0.0f, 0.0f, (float)img.getWidth(obs), (float)imgHeight);
            this.contentStreamRestoreState();
        }
        catch (IOException e) {
            this.throwException(e);
        }
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        try {
            this.contentStreamSaveState();
            int width = dx2 - dx1;
            int height = dy2 - dy1;
            this.walkShape(new Rectangle2D.Double(dx1, dy1, width, height));
            this.contentStream.clip();
            if (bgcolor != null) {
                this.contentStream.setNonStrokingColor(this.colorMapper.mapColor(this.contentStream, bgcolor));
                this.walkShape(new Rectangle(dx1, dy1, width, height));
                this.contentStream.fill();
            }
            AffineTransform tf = new AffineTransform();
            tf.translate(dx1, dy1);
            float imgWidth = img.getWidth(observer);
            float imgHeight = img.getHeight(observer);
            tf.scale((float)width / imgWidth, (float)height / imgHeight);
            tf.translate(-sx1, -sy1);
            tf.scale((float)(sx2 - sx1) / imgWidth, (float)(sy2 - sy1) / imgHeight);
            this.drawImage(img, tf, observer);
            this.contentStreamRestoreState();
            return true;
        }
        catch (IOException e) {
            this.throwException(e);
            return false;
        }
    }

    private void drawStringUsingShapes(AttributedCharacterIterator iterator, float x, float y) {
        Stroke originalStroke = this.stroke;
        Paint originalPaint = this.paint;
        TextLayout textLayout = new TextLayout(iterator, this.getFontRenderContext());
        textLayout.draw(this, x, y);
        this.paint = originalPaint;
        this.stroke = originalStroke;
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        try {
            this.contentStreamSaveState();
            if (this.fontTextDrawer.canDrawText((AttributedCharacterIterator)iterator.clone(), this.fontDrawerEnv())) {
                this.drawStringUsingText(iterator, x, y);
            } else {
                this.drawStringUsingShapes(iterator, x, y);
            }
            this.contentStreamRestoreState();
        }
        catch (IOException e) {
            this.throwException(e);
        }
        catch (FontFormatException e) {
            this.throwException(e);
        }
    }

    private void drawStringUsingText(AttributedCharacterIterator iterator, float x, float y) throws IOException, FontFormatException {
        this.contentStreamSaveState();
        AffineTransform tf = new AffineTransform(this.baseTransform);
        tf.concatenate(this.transform);
        tf.translate(x, y);
        this.contentStream.transform(new Matrix(tf));
        this.fontTextDrawer.drawText(iterator, this.fontDrawerEnv());
        this.contentStreamRestoreState();
    }

    private void contentStreamSaveState() throws IOException {
        ++this.saveCounter;
        this.contentStream.saveGraphicsState();
    }

    private void contentStreamRestoreState() throws IOException {
        if (this.saveCounter == 0) {
            throw new IllegalStateException("Internal save/restore state error. Should never happen.");
        }
        --this.saveCounter;
        this.contentStream.restoreGraphicsState();
    }

    private IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv fontDrawerEnv() {
        return new IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv(){

            @Override
            public PDDocument getDocument() {
                return PdfBoxGraphics2D.this.document;
            }

            @Override
            public PDPageContentStream getContentStream() {
                return PdfBoxGraphics2D.this.contentStream;
            }

            @Override
            public Font getFont() {
                return PdfBoxGraphics2D.this.font;
            }

            @Override
            public Paint getPaint() {
                return PdfBoxGraphics2D.this.paint;
            }

            @Override
            public void applyPaint(Paint paint) throws IOException {
                PDShading pdShading = PdfBoxGraphics2D.this.applyPaint(paint);
                if (pdShading != null) {
                    PdfBoxGraphics2D.this.applyShadingAsColor(pdShading);
                }
            }

            @Override
            public FontRenderContext getFontRenderContext() {
                return PdfBoxGraphics2D.this.getFontRenderContext();
            }

            @Override
            public PDRectangle getGraphicsBBox() {
                return PdfBoxGraphics2D.this.bbox;
            }

            @Override
            public PDResources getResources() {
                return PdfBoxGraphics2D.this.xFormObject.getResources();
            }
        };
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.checkNoCopyActive();
        AffineTransform transformOrig = (AffineTransform)this.transform.clone();
        this.transform.translate(x, y);
        this.fill(g.getOutline());
        this.transform = transformOrig;
    }

    @Override
    public void fill(Shape s) {
        this.checkNoCopyActive();
        try {
            this.contentStreamSaveState();
            PDShading shading = this.applyPaint();
            this.walkShape(s);
            if (shading != null) {
                Rectangle2D r2d = s.getBounds2D();
                if (r2d.getWidth() <= 0.0 || r2d.getHeight() <= 0.0) {
                    this.applyShadingAsColor(shading);
                    this.contentStream.fill();
                } else {
                    this.contentStream.clip();
                    this.contentStream.shadingFill(shading);
                }
            } else {
                this.contentStream.fill();
            }
            this.contentStreamRestoreState();
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    private void applyShadingAsColor(PDShading shading) throws IOException {
        PDTilingPattern pattern = new PDTilingPattern();
        pattern.setPaintType(1);
        pattern.setTilingType(3);
        PDRectangle anchorRect = this.bbox;
        pattern.setBBox(anchorRect);
        pattern.setXStep(anchorRect.getWidth());
        pattern.setYStep(anchorRect.getHeight());
        PDAppearanceStream appearance = new PDAppearanceStream(this.document);
        appearance.setResources(pattern.getResources());
        appearance.setBBox(pattern.getBBox());
        PDPageContentStream imageContentStream = new PDPageContentStream(this.document, appearance, ((COSStream)pattern.getCOSObject()).createOutputStream());
        imageContentStream.addRect(0.0f, 0.0f, anchorRect.getWidth(), anchorRect.getHeight());
        imageContentStream.clip();
        imageContentStream.shadingFill(shading);
        imageContentStream.close();
        PDPattern patternCS1 = new PDPattern(null);
        COSName tilingPatternName = this.xFormObject.getResources().add((PDAbstractPattern)pattern);
        PDColor patternColor = new PDColor(tilingPatternName, (PDColorSpace)patternCS1);
        this.contentStream.setNonStrokingColor(patternColor);
        this.contentStream.setStrokingColor(patternColor);
    }

    private PDShading applyPaint() throws IOException {
        return this.applyPaint(this.paint);
    }

    private PDShading applyPaint(Paint paintToApply) throws IOException {
        AffineTransform tf = new AffineTransform(this.baseTransform);
        tf.concatenate(this.transform);
        return this.paintApplier.applyPaint(paintToApply, this.contentStream, tf, new IPdfBoxGraphics2DPaintApplier.IPaintEnv(){

            @Override
            public IPdfBoxGraphics2DColorMapper getColorMapper() {
                return PdfBoxGraphics2D.this.colorMapper;
            }

            @Override
            public IPdfBoxGraphics2DImageEncoder getImageEncoder() {
                return PdfBoxGraphics2D.this.imageEncoder;
            }

            @Override
            public PDDocument getDocument() {
                return PdfBoxGraphics2D.this.document;
            }

            @Override
            public PDResources getResources() {
                return PdfBoxGraphics2D.this.xFormObject.getResources();
            }

            @Override
            public Composite getComposite() {
                return PdfBoxGraphics2D.this.getComposite();
            }

            @Override
            public PdfBoxGraphics2D getGraphics2D() {
                return PdfBoxGraphics2D.this;
            }
        });
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    @Override
    public void setComposite(Composite comp) {
        this.composite = comp;
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.renderingHints.put(hintKey, hintValue);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.renderingHints.get(hintKey);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        hints.clear();
        this.addRenderingHints(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.renderingHints.putAll(hints);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return new RenderingHints(this.renderingHints);
    }

    @Override
    public PdfBoxGraphics2D create() {
        try {
            return new PdfBoxGraphics2D(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void translate(int x, int y) {
        this.transform.translate(x, y);
    }

    @Override
    public Color getColor() {
        if (this.paint instanceof Color) {
            return (Color)this.paint;
        }
        return null;
    }

    @Override
    public void setColor(Color color) {
        this.paint = color;
    }

    @Override
    public void setPaintMode() {
        this.xorColor = null;
    }

    @Override
    public void setXORMode(Color c1) {
        this.xorColor = c1;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.calcGfx.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        Shape clip = this.getClip();
        if (clip != null) {
            return clip.getBounds();
        }
        return null;
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
        this.clip(rect);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public Shape getClip() {
        try {
            return this.transform.createInverse().createTransformedShape(this.clipShape);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    @Override
    public void setClip(Shape clip) {
        this.checkNoCopyActive();
        this.clipShape = this.transform.createTransformedShape(clip);
        try {
            this.contentStreamRestoreState();
            this.contentStreamSaveState();
            if (clip != null) {
                this.walkShape(clip);
                this.contentStream.clip();
            }
        }
        catch (IOException e) {
            this.throwException(e);
        }
    }

    private static boolean isFinite(float f) {
        return Math.abs(f) <= Float.MAX_VALUE;
    }

    private static boolean isFinite(float[] coords, int count) {
        for (int i = 0; i < count; ++i) {
            if (PdfBoxGraphics2D.isFinite(coords[i])) continue;
            return false;
        }
        return true;
    }

    private void walkShape(Shape clip) throws IOException {
        this.checkNoCopyActive();
        AffineTransform tf = new AffineTransform(this.baseTransform);
        tf.concatenate(this.transform);
        PathIterator pi = clip.getPathIterator(tf);
        float[] coords = new float[6];
        while (!pi.isDone()) {
            int segment = pi.currentSegment(coords);
            switch (segment) {
                case 0: {
                    if (!PdfBoxGraphics2D.isFinite(coords, 2)) break;
                    this.contentStream.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    if (!PdfBoxGraphics2D.isFinite(coords, 2)) break;
                    this.contentStream.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    if (!PdfBoxGraphics2D.isFinite(coords, 4)) break;
                    this.contentStream.curveTo1(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    if (!PdfBoxGraphics2D.isFinite(coords, 6)) break;
                    this.contentStream.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    this.contentStream.closePath();
                }
            }
            pi.next();
        }
    }

    private void checkNoCopyActive() {
        if (this.copyList.size() > 0) {
            throw new IllegalStateException("Don't use the main context as long as a copy is active!");
        }
    }

    private void throwException(Exception e) {
        throw new RuntimeException(e);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new IllegalStateException("copyArea() not possible!");
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Paint p = this.paint;
        this.paint = this.backgroundColor;
        this.fillRect(x, y, width, height);
        this.paint = p;
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Double(x, y, width, height));
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 2));
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        Path2D.Double path = new Path2D.Double();
        path.moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            path.lineTo(xPoints[i], yPoints[i]);
        }
        this.draw(path);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fill(new Polygon(xPoints, yPoints, nPoints));
    }

    @Override
    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.transform.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.transform.concatenate(Tx);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.checkNoCopyActive();
        this.transform = new AffineTransform();
        this.transform.concatenate(Tx);
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    @Override
    public Color getBackground() {
        return this.backgroundColor;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void clip(Shape shape) {
        Shape clip = this.getClip();
        if (clip == null) {
            this.setClip(shape);
        } else {
            Area area = new Area(clip);
            area.intersect(new Area(shape));
            this.setClip(area);
        }
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        this.calcGfx.addRenderingHints(this.renderingHints);
        return this.calcGfx.getFontRenderContext();
    }

    private static class CopyInfo {
        PdfBoxGraphics2D sourceGfx;
        PdfBoxGraphics2D copy;

        private CopyInfo() {
        }
    }
}

