/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.jruby.AbstractJRubyMojo;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.gems.GemManager;
import de.saumya.mojo.ruby.gems.GemsConfig;
import de.saumya.mojo.ruby.gems.GemsInstaller;
import de.saumya.mojo.ruby.script.GemScriptFactory;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGemMojo
extends AbstractJRubyMojo {
    protected UnArchiver unzip;
    protected PluginDescriptor plugin;
    protected boolean includeOpenSSL;
    protected boolean includeRubygemsInTestResources;
    protected boolean installRDoc;
    protected boolean installRI;
    protected boolean gemUseSystem;
    protected File gemHome;
    protected File gemPath;
    protected File binDirectory;
    protected boolean supportNative;
    protected GemManager manager;
    protected GemsConfig gemsConfig;
    protected GemsInstaller gemsInstaller;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getBasedir() == null) {
            this.gemHome = new File(this.gemHome.getAbsolutePath().replace("/${project.basedir}/", "/"));
            this.gemPath = new File(this.gemPath.getAbsolutePath().replace("/${project.basedir}/", "/"));
        }
        this.gemsConfig = new GemsConfig();
        this.gemsConfig.setGemHome(this.gemHome);
        this.gemsConfig.addGemPath(this.gemPath);
        if (this.gemUseSystem && (System.getenv("GEM_HOME") == null || System.getenv("GEM_PATH") == null)) {
            throw new MojoExecutionException("with gemUseSystem set to true you need to provide GEM_HOME and GEM_PATH environment variables !");
        }
        this.gemsConfig.setSystemInstall(this.gemUseSystem);
        this.gemsConfig.setAddRdoc(this.installRDoc);
        this.gemsConfig.setAddRI(this.installRI);
        this.gemsConfig.setBinDirectory(this.binDirectory);
        this.gemsConfig.setSkipJRubyOpenSSL(!this.includeOpenSSL || !this.getJrubyVersion().needsOpenSSL());
        super.execute();
    }

    protected ScriptFactory newScriptFactory(Artifact artifact) throws MojoExecutionException {
        try {
            GemScriptFactory factory;
            GemScriptFactory gemScriptFactory = factory = "jruby-core".equals(artifact.getArtifactId()) ? new GemScriptFactory(this.logger, this.classRealm, artifact.getFile(), this.resolveJRubyStdlibArtifact(artifact).getFile(), this.project.getTestClasspathElements(), this.jrubyFork, this.gemsConfig) : new GemScriptFactory(this.logger, this.classRealm, artifact.getFile(), this.project.getTestClasspathElements(), this.jrubyFork, this.gemsConfig);
            if (this.supportNative) {
                factory.addJvmArgs("-Djruby.home=" + this.setupNativeSupport().getAbsolutePath());
            }
            return factory;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("could not resolve jruby", (Exception)((Object)e));
        }
        catch (ScriptException e) {
            throw new MojoExecutionException("could not initialize script factory", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("could not initialize script factory", (Exception)e);
        }
    }

    private File setupNativeSupport() throws MojoExecutionException {
        File target = new File(this.project.getBuild().getDirectory());
        File jrubyDir = new File(target, "jruby-" + this.getJrubyVersion());
        if (!jrubyDir.exists()) {
            Artifact dist = this.manager.createArtifact("org.jruby", "jruby-dist", this.getJrubyVersion().toString(), "bin", "zip");
            try {
                this.manager.resolve(dist, this.localRepository, this.project.getRemoteArtifactRepositories());
            }
            catch (GemException e) {
                throw new MojoExecutionException("could not setup jruby distribution for native support", (Exception)((Object)e));
            }
            if (this.jrubyVerbose) {
                this.getLog().info((CharSequence)("unzip " + dist.getFile()));
            }
            target.mkdirs();
            this.unzip.setSourceFile(dist.getFile());
            this.unzip.setDestDirectory(target);
            File f = null;
            try {
                this.unzip.extract();
                f = new File(target, "jruby-" + this.getJrubyVersion() + "/bin/jruby");
                Method m = f.getClass().getMethod("setExecutable", Boolean.TYPE);
                m.invoke((Object)f, new Boolean(true));
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("could unzip jruby distribution for native support", (Exception)((Object)e));
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("can not set executable flag: " + f.getAbsolutePath() + " (" + e.getMessage() + ")"));
            }
        }
        return jrubyDir;
    }

    protected void executeJRuby() throws MojoExecutionException, MojoFailureException, IOException, ScriptException {
        this.gemsInstaller = new GemsInstaller(this.gemsConfig, this.factory, this.manager);
        try {
            this.gemsInstaller.installPom(this.project, this.localRepository);
            boolean hasGems = false;
            for (Artifact artifact : this.plugin.getArtifacts()) {
                if (!artifact.getType().contains("gem")) continue;
                hasGems = true;
                break;
            }
            if (hasGems) {
                String base = this.gemsConfig.getGemHome() != null ? this.gemsConfig.getGemHome().getAbsolutePath() : this.project.getBuild().getDirectory() + "/rubygems";
                File pluginGemHome = new File(base + "-" + this.plugin.getArtifactId());
                pluginGemHome.mkdirs();
                this.gemsConfig.setBinDirectory(this.gemsConfig.getBinDirectory());
                File home = this.gemsConfig.getGemHome();
                this.gemsConfig.setGemHome(pluginGemHome);
                this.gemsConfig.addGemPath(pluginGemHome);
                this.gemsInstaller.installGems(this.project, (Collection)this.plugin.getArtifacts(), this.localRepository, this.getRemoteRepos());
                this.gemsConfig.setGemHome(home);
            }
        }
        catch (GemException e) {
            throw new MojoExecutionException("error in installing gems", (Exception)((Object)e));
        }
        if (this.includeRubygemsInTestResources) {
            for (File path : this.gemsConfig.getGemPath()) {
                if (this.jrubyVerbose) {
                    this.getLog().info((CharSequence)("add gems to test-classpath from: " + path.getAbsolutePath()));
                }
                Resource resource = new Resource();
                resource.setDirectory(path.getAbsolutePath());
                resource.addInclude("gems/**");
                resource.addInclude("specifications/**");
                this.project.getBuild().getTestResources().add(resource);
            }
        }
        try {
            this.executeWithGems();
        }
        catch (GemException e) {
            throw new MojoExecutionException("error in executing with gems", (Exception)((Object)e));
        }
    }

    protected abstract void executeWithGems() throws MojoExecutionException, ScriptException, GemException, IOException, MojoFailureException;

    protected List<ArtifactRepository> getRemoteRepos() {
        LinkedList<ArtifactRepository> remotes = new LinkedList<ArtifactRepository>();
        remotes.addAll(this.project.getPluginArtifactRepositories());
        remotes.addAll(this.project.getRemoteArtifactRepositories());
        return remotes;
    }
}

