/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.gem.AbstractGemMojo;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.IOException;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;

public class GenerateResourcesMojo
extends AbstractGemMojo {
    protected List<String> includeRubyResources;
    protected List<String> excludeRubyResources;
    protected boolean includeBinStubs = false;

    protected void executeWithGems() throws MojoExecutionException, ScriptException, IOException, GemException {
        Resource resource;
        if (this.includeRubyResources != null) {
            resource = new Resource();
            resource.setDirectory(this.project.getBasedir().getAbsolutePath());
            for (String include : this.includeRubyResources) {
                resource.addInclude(include);
            }
            if (this.excludeRubyResources != null) {
                for (String exclude : this.excludeRubyResources) {
                    resource.addExclude(exclude);
                }
            }
            this.addResource(this.project.getBuild().getResources(), resource);
        }
        if (this.includeBinStubs) {
            resource = new Resource();
            resource.setDirectory(this.gemsConfig.getBinDirectory().getAbsolutePath());
            resource.addInclude("*");
            resource.setTargetPath("META-INF/jruby.home/bin");
            this.addResource(this.project.getBuild().getResources(), resource);
        }
    }
}

