/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gem;

import de.saumya.mojo.gem.AbstractGemMojo;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="process-resources", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ProcessResourcesMojo
extends AbstractGemMojo {
    @Parameter
    protected List<String> includeRubyResources;
    @Parameter
    protected List<String> excludeRubyResources = Collections.emptyList();

    protected void executeWithGems() throws MojoExecutionException, ScriptException, IOException, GemException {
        File jrubydir = new File(this.project.getBuild().getOutputDirectory(), ".jrubydir");
        if (this.includeRubyResources != null) {
            jrubydir.delete();
            DirectoryScanner scanner = this.scan(this.includeRubyResources.toArray(new String[this.includeRubyResources.size()]), this.excludeRubyResources.toArray(new String[this.excludeRubyResources.size()]));
            this.processBaseDirectory(scanner, jrubydir);
            this.processNestedDiretories(scanner);
        }
        if (this.rubySourceDirectory.exists()) {
            this.processDir(jrubydir, this.rubySourceDirectory);
        }
        if (this.libDirectory.exists() && this.includeLibDirectoryInResources) {
            this.processDir(jrubydir, this.libDirectory);
        }
    }

    private void processDir(File jrubydir, File dir) throws IOException, ScriptException {
        File[] dirs = dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        String[] includes = new String[dirs.length + 1];
        includes[0] = "*";
        int index = 1;
        for (File d : dirs) {
            includes[index++] = d.getName() + "/*";
        }
        DirectoryScanner scanner = this.scan(includes, new String[0]);
        this.processBaseDirectory(scanner, jrubydir);
        this.processNestedDiretories(scanner);
    }

    private void processNestedDiretories(DirectoryScanner scanner) throws IOException, ScriptException {
        String[] directories = scanner.getIncludedDirectories();
        if (directories.length > 0) {
            StringBuilder script = new StringBuilder("require 'jruby/commands';");
            for (String dir : directories) {
                if (dir.contains("/")) continue;
                script.append("JRuby::Commands.generate_dir_info('" + new File(this.project.getBuild().getOutputDirectory(), dir).getAbsolutePath() + "', false) if JRuby::Commands.respond_to? :generate_dir_info;");
            }
            Script s = this.factory.newScript(script.toString());
            s.execute();
        }
    }

    private void processBaseDirectory(DirectoryScanner scanner, File jrubydir) throws IOException {
        String[] files = scanner.getIncludedFiles();
        if (files.length > 0) {
            StringBuilder fileList = jrubydir.exists() ? new StringBuilder(FileUtils.fileRead((File)jrubydir)) : new StringBuilder(".\n");
            for (String file : files) {
                if (file.contains("/")) continue;
                fileList.append(file).append("\n");
            }
            FileUtils.fileWrite((File)jrubydir, (String)fileList.toString());
        }
    }

    private DirectoryScanner scan(String[] includes, String[] excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.project.getBuild().getOutputDirectory());
        scanner.addDefaultExcludes();
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.scan();
        return scanner;
    }
}

