/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.jruby;

import de.saumya.mojo.jruby.AbstractJRubyMojo;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public class CompileMojo
extends AbstractJRubyMojo {
    @Deprecated
    @Parameter
    protected File rubyDirectory;
    @Parameter(property="project.build.outputDirectory", defaultValue="${project.build.outputDirectory}")
    protected File outputDirectory;
    @Parameter(property="jrubyc.ignoreFailue", defaultValue="false")
    protected boolean ignoreFailures;
    @Parameter(property="jrubyc.generateJava", defaultValue="false")
    protected boolean generateJava;
    @Parameter(defaultValue="${basedir}/target/jrubyc-generated-sources")
    protected File generatedJavaDirectory;
    @Parameter(property="jrubyc.verbose", defaultValue="false")
    private boolean jrubycVerbose;

    public void executeJRuby() throws MojoExecutionException, IOException, ScriptException {
        if (this.rubyDirectory != null) {
            this.getLog().warn((CharSequence)"please use rubySourceDirectory instead");
        }
        if (this.generateJava) {
            if (!this.generatedJavaDirectory.exists()) {
                this.generatedJavaDirectory.mkdirs();
            }
            this.project.addCompileSourceRoot(this.generatedJavaDirectory.getAbsolutePath());
        } else if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        Script script = this.factory.newScript("\nrequire 'jruby/jrubyc'\nstatus = JRubyCompiler::compile_argv(ARGV)\nraise 'compilation-error(s)' if status !=0 && !" + this.ignoreFailures);
        if (this.generateJava) {
            script.addArg("--java").addArg("-t", this.fixPathSeparator(this.generatedJavaDirectory));
        } else {
            script.addArg("-t", this.fixPathSeparator(this.outputDirectory));
        }
        if (this.getJrubyVersion().hasJRubycVerbose() && (this.jrubyVerbose || this.jrubycVerbose)) {
            script.addArg("--verbose");
        }
        script.addArg(".");
        script.executeIn(this.rubyDirectory == null ? this.rubySourceDirectory : this.rubyDirectory);
    }

    private String fixPathSeparator(File f) {
        return f.getPath().replace(System.getProperty("file.separator"), "/");
    }
}

