/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gems;

import de.saumya.mojo.ruby.Logger;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemspecConverter {
    private final ScriptFactory factory;
    private final Logger log;

    public GemspecConverter(Logger log, ScriptFactory factory) {
        this.factory = factory;
        this.log = log;
    }

    public void createPom(File gemspec, String jrubyMavenPluginsVersion, File pom) throws ScriptException, IOException {
        this.factory.newScriptFromResource("gem2pom.rb").addArg(gemspec.getAbsolutePath()).addArg(jrubyMavenPluginsVersion).execute(pom);
    }

    public void updateMetadata(List<String> remoteRepositoryIds, String localRepositoryBasedir) throws ScriptException, IOException {
        for (String id : remoteRepositoryIds) {
            if (!id.startsWith("rubygems")) continue;
            this.log.info("updating metadata for " + id);
            this.factory.newScriptFromResource("update_metadata.rb").addArg(id).addArg(localRepositoryBasedir).execute();
        }
    }
}

